-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

if industrialtest.mods.mclRubber then
	return
end

local function onTreetapUse(user,pointed)
	if pointed.type~="node" or not user or not user:is_player() then
		return false
	end
	local node=minetest.get_node_or_nil(pointed.under)
	if not node then
		return false
	end
	-- Note: if more nodes from which treetap can extract will be added then they shouldn't be added here
	-- Instead they should have additional entry in definition which will denote that treetap can be used on them
	if node.name=="industrialtest:rubber_wood_with_rubber" then
		local inv=user:get_inventory()
		inv:add_item("main",ItemStack("industrialtest:sticky_resin"))
		minetest.set_node(pointed.under,{name="industrialtest:rubber_wood"})
		return true
	end
	return false
end

local S=minetest.get_translator("industrialtest")
industrialtest.Treetap=table.copy(industrialtest.Tool)
industrialtest.internal.unpackTableInto(industrialtest.Treetap,{
	name="industrialtest:treetap",
	define={onPlace=true},
	description=S("Treetap"),
	inventoryImage="industrialtest_treetap.png",
	uses=50,
	flammable=2,
	repairMaterial="group:wood"
})

function industrialtest.Treetap.use(self,itemstack,user,pointed)
	return onTreetapUse(user,pointed)
end

industrialtest.Treetap:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:treetap",
	recipe={
		{"","group:wood",""},
		{"group:wood","group:wood","group:wood"},
		{"group:wood","",""}
	}
})

industrialtest.ElectricTreetap=table.copy(industrialtest.ElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricTreetap,{
	name="industrialtest:electric_treetap",
	define={onPlace=true},
	description=S("Electric Treetap"),
	inventoryImage="industrialtest_electric_treetap.png",
	capacity=10000,
	flow=industrialtest.api.lvPowerFlow
})

function industrialtest.ElectricTreetap.use(self,itemstack,user,pointed)
	return onTreetapUse(user,pointed)
end

function industrialtest.ElectricTreetap.getOpPower(self,itemstack)
	return 50
end

industrialtest.ElectricTreetap:register()

minetest.register_craft({
	type="shapeless",
	output="industrialtest:electric_treetap",
	recipe={
		"industrialtest:treetap",
		"industrialtest:electronic_circuit",
		"industrialtest:re_battery"
	}
})
