-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local modpath=minetest.get_modpath("industrialtest")

-- table with global functions, variables etc
industrialtest={}

-- Settings
industrialtest.config={
	updateDelay=tonumber(minetest.settings:get("industrialtest.updateDelay") or "1"),
	electrocution=minetest.settings:get_bool("industrialtest.electrocution",true),
	developerMode=minetest.settings:get_bool("industrialtest.developerMode",false)
}

-- Others
industrialtest.random=PseudoRandom(os.time())

-- load other lua files
dofile(modpath.."/compatibility.lua")
dofile(modpath.."/minerals.lua")

dofile(modpath.."/api/common.lua")
dofile(modpath.."/api/fluid.lua")
dofile(modpath.."/api/network.lua")
dofile(modpath.."/api/power.lua")
dofile(modpath.."/api/registration.lua")
dofile(modpath.."/api/side.lua")

dofile(modpath.."/machines/machine.lua")
dofile(modpath.."/machines/activated_machine.lua")
dofile(modpath.."/machines/electric_machine.lua")
dofile(modpath.."/machines/activated_electric_machine.lua")
dofile(modpath.."/machines/simple_electric_item_processor.lua")
dofile(modpath.."/machines/canning_machine.lua")
dofile(modpath.."/machines/chargepad.lua")
dofile(modpath.."/machines/compressor.lua")
dofile(modpath.."/machines/cable_former.lua")
dofile(modpath.."/machines/electric_furnace.lua")
dofile(modpath.."/machines/extractor.lua")
dofile(modpath.."/machines/fluid_generator.lua")
dofile(modpath.."/machines/generator.lua")
dofile(modpath.."/machines/induction_furnace.lua")
dofile(modpath.."/machines/iron_furnace.lua")
dofile(modpath.."/machines/macerator.lua")
dofile(modpath.."/machines/magnetizer.lua")
dofile(modpath.."/machines/mass_fabricator.lua")
dofile(modpath.."/machines/miner.lua")
dofile(modpath.."/machines/nuclear_reactor.lua")
dofile(modpath.."/machines/power_storage.lua")
dofile(modpath.."/machines/pump.lua")
dofile(modpath.."/machines/recycler.lua")
dofile(modpath.."/machines/rotary_macerator.lua")
dofile(modpath.."/machines/tool_workshop.lua")
dofile(modpath.."/machines/transformer.lua")
dofile(modpath.."/machines/solar_panel_generator.lua")
dofile(modpath.."/machines/wind_mill.lua")

dofile(modpath.."/tools/common.lua")
dofile(modpath.."/tools/item.lua")
dofile(modpath.."/tools/electric_item.lua")
dofile(modpath.."/tools/electric_armor.lua")
dofile(modpath.."/tools/fluid_container_item.lua")
dofile(modpath.."/tools/tool.lua")
dofile(modpath.."/tools/gear_tool.lua")
dofile(modpath.."/tools/electric_tool.lua")
dofile(modpath.."/tools/activated_electric_tool.lua")
dofile(modpath.."/tools/electric_gear_tool.lua")
dofile(modpath.."/tools/batpack.lua")
dofile(modpath.."/tools/electric_chainsaw.lua")
dofile(modpath.."/tools/electric_drill.lua")
dofile(modpath.."/tools/electric_hoe.lua")
dofile(modpath.."/tools/electric_saber.lua")
dofile(modpath.."/tools/fluid_storage.lua")
dofile(modpath.."/tools/jetpack.lua")
dofile(modpath.."/tools/mining_laser.lua")
dofile(modpath.."/tools/nano_suit.lua")
dofile(modpath.."/tools/power_storage.lua")
dofile(modpath.."/tools/scanner.lua")
dofile(modpath.."/tools/solar_helmet.lua")
dofile(modpath.."/tools/static_boots.lua")
dofile(modpath.."/tools/treetap.lua")
dofile(modpath.."/tools/quantum_suit.lua")
dofile(modpath.."/tools/wrench.lua")

dofile(modpath.."/upgrades.lua")
dofile(modpath.."/craftitems.lua")
dofile(modpath.."/guide.lua")
dofile(modpath.."/nodes.lua")
if industrialtest.config.developerMode then
	dofile(modpath.."/utils.lua")
end
dofile(modpath.."/cables.lua")
dofile(modpath.."/mapgen.lua")
dofile(modpath.."/uu_matter_crafts.lua")
dofile(modpath.."/crafts.lua")

-- compatibility with other mods
if industrialtest.mods.pipeworks then
	dofile(modpath.."/compat/pipeworks.lua")
end
if industrialtest.mods.logistica then
	dofile(modpath.."/compat/logistica.lua")
end
if industrialtest.mods.mesecons then
	dofile(modpath.."/compat/mesecons.lua")
end
