-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.Macerator=table.copy(industrialtest.SimpleElectricItemProcessor)
industrialtest.internal.unpackTableInto(industrialtest.Macerator,{
	name="industrialtest:macerator",
	description=S("Macerator"),
	tiles={
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png^industrialtest_macerator_front.png"
	},
	requiresWrench=true,
	active={
		tiles={
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png^industrialtest_macerator_front_active.png"
		}
	},
	capacity=1200,
	flow=industrialtest.api.lvPowerFlow,
	opPower=100,
	efficiency=1
})

function industrialtest.Macerator.getCraftResult(self,itemstack)
	local output=industrialtest.api.getMaceratorRecipeResult(itemstack:get_name())
	if not output then
		return {
			item=ItemStack(),
			time=0,
			src=itemstack
		}
	end
	local srcAfter=ItemStack(itemstack:get_name())
	srcAfter:set_count(itemstack:get_count()-1)
	return {
		item=ItemStack(output.output),
		time=output.time,
		src=srcAfter
	}
end

industrialtest.Macerator:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:macerator",
	recipe={
		{industrialtest.elementKeys.flint,industrialtest.elementKeys.flint,industrialtest.elementKeys.flint},
		{industrialtest.elementKeys.cobble,"industrialtest:machine_block",industrialtest.elementKeys.cobble},
		{"","industrialtest:electronic_circuit",""}
	}
})
