-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.MassFabricator=table.copy(industrialtest.SimpleElectricItemProcessor)
industrialtest.internal.unpackTableInto(industrialtest.MassFabricator,{
	name="industrialtest:mass_fabricator",
	description=S("Mass Fabricator"),
	tiles={
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png^industrialtest_mass_fabricator_front.png"
	},
	requiresWrench=true,
	active={
		tiles={
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png^industrialtest_mass_fabricator_front_active.png"
		}
	},
	capacity=100000,
	flow=industrialtest.api.evPowerFlow,
	opPower=10000,
	efficiency=1
})

function industrialtest.MassFabricator.getCraftResult(self,itemstack)
	if itemstack:get_count()<34 or itemstack:get_name()~="industrialtest:scrap" then
		return {
			item=ItemStack(),
			time=0,
			src=itemstack
		}
	end
	local srcAfter=ItemStack(itemstack:get_name())
	srcAfter:set_count(itemstack:get_count()-34)
	return {
		item=ItemStack("industrialtest:uu_matter"),
		time=15,
		src=srcAfter
	}
end

industrialtest.MassFabricator:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:mass_fabricator",
	recipe={
		{industrialtest.elementKeys.yellowDust,"industrialtest:advanced_circuit",industrialtest.elementKeys.yellowDust},
		{"industrialtest:advanced_machine_block","industrialtest:lapotron_crystal","industrialtest:advanced_machine_block"},
		{industrialtest.elementKeys.yellowDust,"industrialtest:advanced_circuit",industrialtest.elementKeys.yellowDust}
	}
})
