-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.SolarHelmet=table.copy(industrialtest.GearTool)
industrialtest.internal.unpackTableInto(industrialtest.SolarHelmet,{
	name="industrialtest:solar_helmet",
	description=S("Solar Helmet"),
	inventoryImage="industrialtest_solar_helmet_inv.png",
	part="head",
	modelImage="industrialtest_solar_helmet.png"
})

local updateDelta=0
function industrialtest.SolarHelmet.update(self,player,inv,itemstack,dtime)
	updateDelta=updateDelta+dtime
	if updateDelta<industrialtest.config.updateDelay then
		return false
	end
	updateDelta=0

	local amount=math.floor((minetest.get_node_light(player:get_pos()) or 0)/2)
	if amount==0 then
		return false
	end
	local armorList=inv:get_list("armor")
	for i,armorItemstack in ipairs(armorList) do
		local meta=armorItemstack:get_meta()
		if industrialtest.api.hasPowerStorage(meta) and not industrialtest.api.isFullyCharged(meta) then
			industrialtest.api.addPowerToItem(armorItemstack,amount)
			inv:set_stack("armor",i,armorItemstack)
			break
		end
	end
	return false
end

industrialtest.SolarHelmet:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:solar_helmet",
	recipe={
		{industrialtest.elementKeys.ironIngot,industrialtest.elementKeys.ironIngot,industrialtest.elementKeys.ironIngot},
		{industrialtest.elementKeys.ironIngot,"industrialtest:solar_panel",industrialtest.elementKeys.ironIngot},
		{"industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable"}
	}
})

minetest.register_craft({
	type="shaped",
	output="industrialtest:solar_helmet",
	recipe={
		{"",industrialtest.elementKeys.ironHelmet,""},
		{"","industrialtest:solar_panel",""},
		{"industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable"}
	}
})
