-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.StaticBoots=table.copy(industrialtest.GearTool)

local image=(industrialtest.mtgAvailable and "industrialtest_static_boots.png" or "industrialtest_mcl_static_boots.png")

industrialtest.internal.unpackTableInto(industrialtest.StaticBoots,{
	name="industrialtest:static_boots",
	description=S("Static Boots"),
	inventoryImage="industrialtest_static_boots_inv.png",
	part="feet",
	modelImage=image
})

local updateDelta=0
local playerPositions={}
function industrialtest.StaticBoots.update(self,player,inv,itemstack,dtime)
	local playerPos=player:get_pos()
	playerPos.y=0
	if not playerPositions[player:get_player_name()] then
		playerPositions[player:get_player_name()]=playerPos
		return false
	end
	if vector.distance(playerPos,playerPositions[player:get_player_name()])<5 then
		return false
	end
	playerPositions[player:get_player_name()]=playerPos
	local armorList=inv:get_list("armor")
	for i,armorItemstack in ipairs(armorList) do
		local meta=armorItemstack:get_meta()
		if industrialtest.api.hasPowerStorage(meta) and not industrialtest.api.isFullyCharged(meta) then
			industrialtest.api.addPowerToItem(armorItemstack,1)
			inv:set_stack("armor",i,armorItemstack)
			break
		end
	end
	return false
end

industrialtest.StaticBoots:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:static_boots",
	recipe={
		{industrialtest.elementKeys.ironIngot,"",industrialtest.elementKeys.ironIngot},
		{industrialtest.elementKeys.ironIngot,industrialtest.elementKeys.whiteWool,industrialtest.elementKeys.ironIngot},
		{"industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable"}
	}
})

minetest.register_craft({
	type="shaped",
	output="industrialtest:static_boots",
	recipe={
		{"",industrialtest.elementKeys.ironBoots,""},
		{"",industrialtest.elementKeys.whiteWool,""},
		{"industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable"}
	}
})

minetest.register_on_leaveplayer(function(player)
	playerPositions[player:get_player_name()]=nil
end)
