-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.Tool=table.copy(industrialtest.Item)
industrialtest.internal.unpackTableInto(industrialtest.Tool,{
	define={}
})

function industrialtest.Tool.use(self,itemstack,user,pointed)
	-- dummy function
	return false
end

function industrialtest.Tool.hitUse(self,itemstack,user,pointed)
	-- Note: this method, when used, onUse must be set in define table
	-- dummy function
	return false
end

function industrialtest.Tool.onPlace(self,itemstack,user,pointed)
	if self:use(itemstack,user,pointed) then
		local meta=itemstack:get_meta()
		if not meta:contains("industrialtest.uses") then
			self:prepare(itemstack)
		end
		local uses=meta:get_int("industrialtest.uses")-1
		if uses==0 then
			itemstack:set_count(0)
			minetest.sound_play({name="default_tool_breaks"},{
				gain=1,
				fade=0,
				pitch=1
			},true)
			return true
		end
		meta:set_int("industrialtest.uses",uses)
		itemstack:set_wear(65535-uses/self.uses*65535)
		return true
	end
	return false
end

function industrialtest.Tool.onUse(self,itemstack,user,pointed)
	if self:hitUse(itemstack,user,pointed) then
		local meta=itemstack:get_meta()
		if not meta:contains("industrialtest.uses") then
			self:prepare(itemstack)
		end
		local uses=meta:get_int("industrialtest.uses")-1
		if uses==0 then
			itemstack:set_count(0)
			minetest.sound_play({name="default_tool_breaks"},{
				gain=1,
				fade=0,
				pitch=1
			},true)
			return true
		end
		meta:set_int("industrialtest.uses",uses)
		itemstack:set_wear(65535-uses/self.uses*65535)
		return true
	end
	return false
end

function industrialtest.Tool.prepare(self,itemstack)
	local meta=itemstack:get_meta()
	meta:set_int("industrialtest.uses",self.uses)
end

function industrialtest.Tool.createDefinitionTable(self)
	local def=industrialtest.Item.createDefinitionTable(self)
	def.tool_capabilities={
		uses=self.uses
	}
	if self.define.onPlace then
		def.on_place=function(itemstack,user,pointed)
			if self:onPlace(itemstack,user,pointed) then
				return itemstack
			end
			return nil
		end
	end
	if self.define.onUse then
		def.on_use=function(itemstack,user,pointed)
			if self:onUse(itemstack,user,pointed) then
				return itemstack
			end
			return nil
		end
	end

	if industrialtest.mclAvailable then
		def.groups={
			tool=1
		}
		def._repair_material=self.repairMaterial
		def._mcl_toollike_wield=true
	end

	return def
end
