-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Coal Block (off state) node
minetest.register_node("camomese:mesecore_coalblock", {
	description = S("Mese Core Coal Block"),
	tiles = {"camomese_mesecore_coal_block.png"},
	is_ground_content = false,
	inventory_image = minetest.inventorycube("camomese_mesecore_coal_block.png"),
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.off,
		rules = mesecon.rules.alldirs,
		onstate = "camomese:mesecore_coalblock_on"
	}},
	on_blast = mesecon.on_blastnode,
})

-- Register the Mese Core Cobblestone (on state) node
minetest.register_node("camomese:mesecore_coalblock_on", {
    tiles = {"camomese_mesecore_coal_block_on.png"},
	is_ground_content = false,
	groups = {cracky = 3},
	drop = "camomese:mesecore_coalblock",
	sounds = default.node_sound_stone_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.on,
		rules = mesecon.rules.alldirs,
		offstate = "camomese:mesecore_coalblock"
	}},
	on_blast = mesecon.on_blastnode,
})

-- Register the recipe
minetest.register_craft({
	output = "camomese:mesecore_coalblock 8",
	recipe = {
		{"default:coalblock", "default:coalblock", "default:coalblock"},
		{"default:coalblock", "default:mese_crystal_fragment", "default:coalblock"},
		{"default:coalblock", "default:coalblock", "default:coalblock"},
	}
})
