-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Steel Block (off state) node
minetest.register_node("camomese:mesecore_steelblock", {
	description = S("Mese Core Steel Block"),
	tiles = {"camomese_mesecore_steel_block.png"},
	is_ground_content = false,
	inventory_image = minetest.inventorycube("camomese_mesecore_steel_block.png"),
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.off,
		rules = mesecon.rules.alldirs,
		onstate = "camomese:mesecore_steelblock_on"
	}},
	on_blast = mesecon.on_blastnode,
})

-- Register the Mese Core Cobblestone (on state) node
minetest.register_node("camomese:mesecore_steelblock_on", {
    tiles = {"camomese_mesecore_steel_block_on.png"},
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	drop = "camomese:mesecore_steelblock",
	sounds = default.node_sound_stone_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.on,
		rules = mesecon.rules.alldirs,
		offstate = "camomese:mesecore_steelblock"
	}},
	on_blast = mesecon.on_blastnode,
})

-- Register the recipe
minetest.register_craft({
	output = "camomese:mesecore_steelblock 8",
	recipe = {
		{"default:steelblock", "default:steelblock", "default:steelblock"},
		{"default:steelblock", "default:mese_crystal_fragment", "default:steelblock"},
		{"default:steelblock", "default:steelblock", "default:steelblock"},
	}
})
