-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Sandstone Block node
minetest.register_node("camomese:digicore_sandstone_block", {
    description = S("Digiline Core Sandstone Block"),
    tiles = {"camomese_digicore_sandstone_block.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("camomese_digicore_sandstone_block.png"),
    groups = {cracky = 2},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_sandstone_block 8",
    recipe = {
        {"default:sandstone_block", "default:sandstone_block", "default:sandstone_block"},
        {"default:sandstone_block", "digilines:wire_std_00000000", "default:sandstone_block"},
        {"default:sandstone_block", "default:sandstone_block", "default:sandstone_block"},
    }
})
