-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Desert Sandstone Brick node
minetest.register_node("camomese:digicore_desert_sandstone_brick", {
    description = S("Digiline Core Desert Sandstone Brick"),
    paramtype2 = "facedir",
    place_param2 = 0,
    tiles = {"camomese_digicore_desert_sandstone_brick.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("camomese_digicore_desert_sandstone_brick.png"),
    groups = {cracky = 2},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_desert_sandstone_brick 8",
    recipe = {
        {"default:desert_sandstone_brick", "default:desert_sandstone_brick", "default:desert_sandstone_brick"},
        {"default:desert_sandstone_brick", "digilines:wire_std_00000000", "default:desert_sandstone_brick"},
        {"default:desert_sandstone_brick", "default:desert_sandstone_brick", "default:desert_sandstone_brick"},
    }
})
