-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Tin Block (off state) node
minetest.register_node("camomese:digicore_tinblock", {
    description = S("Digiline Core Tin Block"),
    tiles = {"camomese_digicore_tin_block.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("camomese_digicore_tin_block.png"),
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_tinblock 8",
    recipe = {
        {"default:tinblock", "default:tinblock", "default:tinblock"},
        {"default:tinblock", "digilines:wire_std_00000000", "default:tinblock"},
        {"default:tinblock", "default:tinblock", "default:tinblock"},
    }
})
