-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Apple Wood Planks node
minetest.register_node("camomese:digicore_wood", {
    description = S("Digiline Core Apple Wood Planks"),
    paramtype2 = "facedir",
    place_param2 = 0,
    tiles = {"camomese_digicore_wood.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("camomese_digicore_wood.png"),
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
    sounds = default.node_sound_wood_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_wood 8",
    recipe = {
        {"default:wood", "default:wood", "default:wood"},
        {"default:wood", "digilines:wire_std_00000000", "default:wood"},
        {"default:wood", "default:wood", "default:wood"},
    }
})
