-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Brick Block (off state) node
minetest.register_node("camomese:mesecore_brick", {
	description = S("Mese Core Brick Block"),
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {
		"camomese_mesecore_brick.png^[transformFX",
		"camomese_mesecore_brick.png",
	},
	is_ground_content = false,
	inventory_image = minetest.inventorycube("camomese_mesecore_brick.png"),
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.off,
		rules = mesecon.rules.alldirs,
		onstate = "camomese:mesecore_brick_on"
	}},
	on_blast = mesecon.on_blastnode,
})

-- Register the Mese Core Cobblestone (on state) node
minetest.register_node("camomese:mesecore_brick_on", {
	tiles = {
		"camomese_mesecore_brick_on.png^[transformFX",
		"camomese_mesecore_brick_on.png",
	},
	is_ground_content = false,
	groups = {cracky = 3},
	drop = "camomese:mesecore_brick",
	sounds = default.node_sound_stone_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.on,
		rules = mesecon.rules.alldirs,
		offstate = "camomese:mesecore_brick"
	}},
	on_blast = mesecon.on_blastnode,
})

-- Register the recipe
minetest.register_craft({
	output = "camomese:mesecore_brick 8",
	recipe = {
		{"default:brick", "default:brick", "default:brick"},
		{"default:brick", "default:mese_crystal_fragment", "default:brick"},
		{"default:brick", "default:brick", "default:brick"},
	}
})
