-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Coal Block (off state) node
minetest.register_node("camomese:digicore_coalblock", {
    description = S("Digiline Core Coal Block"),
    tiles = {"default_coal_block.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_coal_block.png^camomese_digicore.png"),
    groups = {cracky = 3},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_coalblock 8",
    recipe = {
        {"default:coalblock", "default:coalblock", "default:coalblock"},
        {"default:coalblock", "digilines:wire_std_00000000", "default:coalblock"},
        {"default:coalblock", "default:coalblock", "default:coalblock"},
    }
})
