-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Desert Stone Block node
minetest.register_node("camomese:digicore_desert_stone_block", {
    description = S("Digiline Core Desert Stone Block"),
    tiles = {"default_desert_stone_block.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_desert_stone_block.png^camomese_digicore.png"),
    groups = {cracky = 3},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_desert_stone_block 8",
    recipe = {
        {"default:desert_stone_block", "default:desert_stone_block", "default:desert_stone_block"},
        {"default:desert_stone_block", "digilines:wire_std_00000000", "default:desert_stone_block"},
        {"default:desert_stone_block", "default:desert_stone_block", "default:desert_stone_block"},
    }
})
