-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Acacia Tree (off state) node
minetest.register_node("camomese:mesecore_acacia_tree", {
    description = S("Mese Core Acacia Tree"),
    paramtype2 = "facedir",
    tiles = {"default_acacia_tree_top.png^camomese_mesecore_off.png", "default_acacia_tree_top.png^camomese_mesecore_off.png", "default_acacia_tree.png^camomese_mesecore_off.png"},
    is_ground_content = false,
    groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
    sounds = default.node_sound_wood_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.off,
        rules = mesecon.rules.alldirs,
        onstate = "camomese:mesecore_acacia_tree_on"
    }},
    on_place = minetest.rotate_node
})

-- Register the Mese Core Acacia Tree (on state) node
minetest.register_node("camomese:mesecore_acacia_tree_on", {
    paramtype2 = "facedir",
    tiles = {"default_acacia_tree_top.png^camomese_mesecore_on.png", "default_acacia_tree_top.png^camomese_mesecore_on.png", "default_acacia_tree.png^camomese_mesecore_on.png"},
    is_ground_content = false,
    groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
    drop = "camomese:mesecore_acacia_tree",
    sounds = default.node_sound_wood_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.on,
        rules = mesecon.rules.alldirs,
        offstate = "camomese:mesecore_acacia_tree"
    }},
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:mesecore_acacia_tree 8",
    recipe = {
        {"default:acacia_tree", "default:acacia_tree", "default:acacia_tree"},
        {"default:acacia_tree", "default:mese_crystal_fragment", "default:acacia_tree"},
        {"default:acacia_tree", "default:acacia_tree", "default:acacia_tree"},
    }
})
