-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Diamond Block (off state) node
minetest.register_node("camomese:mesecore_diamondblock", {
    description = S("Mese Core Diamond Block"),
    tiles = {"default_diamond_block.png^camomese_mesecore_off.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_diamond_block.png^camomese_mesecore_off.png"),
    groups = {cracky = 1, level = 3},
    sounds = default.node_sound_stone_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.off,
        rules = mesecon.rules.alldirs,
        onstate = "camomese:mesecore_diamondblock_on"
    }},
    on_blast = mesecon.on_blastnode,
})

-- Register the Mese Core Cobblestone (on state) node
minetest.register_node("camomese:mesecore_diamondblock_on", {
    tiles = {"default_diamond_block.png^camomese_mesecore_on.png"},
    is_ground_content = false,
    groups = {cracky = 1, level = 3},
    drop = "camomese:mesecore_diamondblock",
    sounds = default.node_sound_stone_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.on,
        rules = mesecon.rules.alldirs,
        offstate = "camomese:mesecore_diamondblock"
    }},
    on_blast = mesecon.on_blastnode,
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:mesecore_diamondblock 8",
    recipe = {
        {"default:diamondblock", "default:diamondblock", "default:diamondblock"},
        {"default:diamondblock", "default:mese_crystal_fragment", "default:diamondblock"},
        {"default:diamondblock", "default:diamondblock", "default:diamondblock"},
    }
})
