-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Bronze Block (off state) node
minetest.register_node("camomese:mesecore_bronzeblock", {
    description = S("Mese Core Bronze Block"),
    tiles = {"default_bronze_block.png^camomese_mesecore_off.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_bronze_block.png^camomese_mesecore_off.png"),
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.off,
        rules = mesecon.rules.alldirs,
        onstate = "camomese:mesecore_bronzeblock_on"
    }},
    on_blast = mesecon.on_blastnode,
})

-- Register the Mese Core Cobblestone (on state) node
minetest.register_node("camomese:mesecore_bronzeblock_on", {
    tiles = {"default_bronze_block.png^camomese_mesecore_on.png"},
    is_ground_content = false,
    groups = {cracky = 1, level = 2},
    drop = "camomese:mesecore_bronzeblock",
    sounds = default.node_sound_stone_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.on,
        rules = mesecon.rules.alldirs,
        offstate = "camomese:mesecore_bronzeblock"
    }},
    on_blast = mesecon.on_blastnode,
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:mesecore_bronzeblock 8",
    recipe = {
        {"default:bronzeblock", "default:bronzeblock", "default:bronzeblock"},
        {"default:bronzeblock", "default:mese_crystal_fragment", "default:bronzeblock"},
        {"default:bronzeblock", "default:bronzeblock", "default:bronzeblock"},
    }
})
