-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Gold Block (off state) node
minetest.register_node("camomese:digicore_goldblock", {
    description = S("Digiline Core Gold Block"),
    tiles = {"default_gold_block.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_gold_block.png^camomese_digicore.png"),
    groups = {cracky = 1},
    sounds = default.node_sound_metal_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_goldblock 8",
    recipe = {
        {"default:goldblock", "default:goldblock", "default:goldblock"},
        {"default:goldblock", "digilines:wire_std_00000000", "default:goldblock"},
        {"default:goldblock", "default:goldblock", "default:goldblock"},
    }
})
