-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Sandstone Brick node
minetest.register_node("camomese:digicore_sandstonebrick", {
    description = S("Digiline Core Sandstone Brick"),
    paramtype2 = "facedir",
    place_param2 = 0,
    tiles = {"default_sandstone_brick.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_sandstone_brick.png^camomese_digicore.png"),
    groups = {cracky = 2},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_sandstonebrick 8",
    recipe = {
        {"default:sandstonebrick", "default:sandstonebrick", "default:sandstonebrick"},
        {"default:sandstonebrick", "digilines:wire_std_00000000", "default:sandstonebrick"},
        {"default:sandstonebrick", "default:sandstonebrick", "default:sandstonebrick"},
    }
})
