-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Stone Brick node
minetest.register_node("camomese:digicore_stonebrick", {
    description = S("Digiline Core Stone Brick"),
    tiles = {"default_stone_brick.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_stone_brick.png^camomese_digicore.png"),
    groups = {cracky = 2, stone = 1},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_stonebrick 8",
    recipe = {
        {"default:stonebrick", "default:stonebrick", "default:stonebrick"},
        {"default:stonebrick", "digilines:wire_std_00000000", "default:stonebrick"},
        {"default:stonebrick", "default:stonebrick", "default:stonebrick"},
    }
})
