-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Mese Core Gold Block (off state) node
minetest.register_node("camomese:mesecore_goldblock", {
    description = S("Mese Core Gold Block"),
    tiles = {"default_gold_block.png^camomese_mesecore_off.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_gold_block.png^camomese_mesecore_off.png"),
    groups = {cracky = 1},
    sounds = default.node_sound_metal_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.off,
        rules = mesecon.rules.alldirs,
        onstate = "camomese:mesecore_goldblock_on"
    }},
    on_blast = mesecon.on_blastnode,
})

-- Register the Mese Core Cobblestone (on state) node
minetest.register_node("camomese:mesecore_goldblock_on", {
    tiles = {"default_gold_block.png^camomese_mesecore_on.png"},
    is_ground_content = false,
    groups = {cracky = 1},
    drop = "camomese:mesecore_goldblock",
    sounds = default.node_sound_stone_defaults(),
    mesecons = {conductor = {
        state = mesecon.state.on,
        rules = mesecon.rules.alldirs,
        offstate = "camomese:mesecore_goldblock"
    }},
    on_blast = mesecon.on_blastnode,
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:mesecore_goldblock 8",
    recipe = {
        {"default:goldblock", "default:goldblock", "default:goldblock"},
        {"default:goldblock", "default:mese_crystal_fragment", "default:goldblock"},
        {"default:goldblock", "default:goldblock", "default:goldblock"},
    }
})
