-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Acacia Tree node
minetest.register_node("camomese:digicore_acacia_tree", {
    description = S("Digiline Core Acacia Tree"),
    paramtype2 = "facedir",
    is_ground_content = false,
    tiles = {"default_acacia_tree_top.png^camomese_digicore.png", "default_acacia_tree_top.png^camomese_digicore.png", "default_acacia_tree.png^camomese_digicore.png"},
    groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
    sounds = default.node_sound_wood_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_acacia_tree 8",
    recipe = {
        {"default:acacia_tree", "default:acacia_tree", "default:acacia_tree"},
        {"default:acacia_tree", "digilines:wire_std_00000000", "default:acacia_tree"},
        {"default:acacia_tree", "default:acacia_tree", "default:acacia_tree"},
    }
})
