-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Aspen Tree node
minetest.register_node("camomese:digicore_aspen_tree", {
    description = S("Digiline Core Aspen Tree"),
    paramtype2 = "facedir",
    is_ground_content = false,
    tiles = {"default_aspen_tree_top.png^camomese_digicore.png", "default_aspen_tree_top.png^camomese_digicore.png", "default_aspen_tree.png^camomese_digicore.png"},
    groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
    sounds = default.node_sound_wood_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_aspen_tree 8",
    recipe = {
        {"default:aspen_tree", "default:aspen_tree", "default:aspen_tree"},
        {"default:aspen_tree", "digilines:wire_std_00000000", "default:aspen_tree"},
        {"default:aspen_tree", "default:aspen_tree", "default:aspen_tree"},
    }
})
