-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Brick Block (off state) node
minetest.register_node("camomese:digicore_brick", {
    description = S("Digiline Core Brick Block"),
    paramtype2 = "facedir",
    place_param2 = 0,
    tiles = {
        "default_brick.png^camomese_digicore.png^[transformFX",
        "default_brick.png^camomese_digicore.png",
    },
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_brick.png^camomese_digicore.png"),
    groups = {cracky = 3},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_brick 8",
    recipe = {
        {"default:brick", "default:brick", "default:brick"},
        {"default:brick", "digilines:wire_std_00000000", "default:brick"},
        {"default:brick", "default:brick", "default:brick"},
    }
})
