-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Sandstone node
minetest.register_node("camomese:digicore_sandstone", {
    description = S("Digiline Core Sandstone"),
    tiles = {"default_sandstone.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_sandstone.png^camomese_digicore.png"),
    groups = {crumbly = 1, cracky = 3},
    sounds = default.node_sound_stone_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_sandstone 8",
    recipe = {
        {"default:sandstone", "default:sandstone", "default:sandstone"},
        {"default:sandstone", "digilines:wire_std_00000000", "default:sandstone"},
        {"default:sandstone", "default:sandstone", "default:sandstone"},
    }
})
