-- Translation support
local S = minetest.get_translator("camomese")

-- Register the Digiline Core Steel Block (off state) node
minetest.register_node("camomese:digicore_steelblock", {
    description = S("Digiline Core Steel Block"),
    tiles = {"default_steel_block.png^camomese_digicore.png"},
    is_ground_content = false,
    inventory_image = minetest.inventorycube("default_steel_block.png^camomese_digicore.png"),
    groups = {cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults(),
    digilines = {
        wire = {
            rules = {
                { x =  0, y =  0, z = -1 },
                { x =  1, y =  0, z =  0 },
                { x = -1, y =  0, z =  0 },
                { x =  0, y =  0, z =  1 },
                { x =  0, y =  1, z =  0 },
                { x =  0, y = -1, z =  0 }
            },
        },
    },
})

-- Register the recipe
minetest.register_craft({
    output = "camomese:digicore_steelblock 8",
    recipe = {
        {"default:steelblock", "default:steelblock", "default:steelblock"},
        {"default:steelblock", "digilines:wire_std_00000000", "default:steelblock"},
        {"default:steelblock", "default:steelblock", "default:steelblock"},
    }
})
