# Camouflaged Mesecons (Camomese) Mod

The **Camomese** mod allows you to embed mesecon and digiline circuitry into
aesthetically pleasing blocks, seamlessly integrating advanced functionality
into your builds while minimizing clutter.

**Camomese** provides you with a way to seamlessly integrate subtle mesecon and
digiline circuitry across your existing builds without sacrificing too much on
aesthetics.

This mod consists of two groups of new blocks:
1. **Mese Core** nodes (searchable as "mesecore") to integrate simple mese-powered circuitry
2. **Digiline Core** nodes (searchable as "digicore") to integrate digiline functionality

As implied by the "core" in the name, *mese core* and *digiline core* nodes have a
mesecon and a digiline wire embedded within the block which allows it to
conduct mesecon power or relay digiline signals.

In order to differentiate *mese core* and *digiline core* blocks from the surrounding
blocks, they each have a tiny spot in the middle of each face where the mesecon
or digiline material shows through.


## Key Benefits and Features

- **Aesthetic Integration**: Hide wires and circuits within visually appealing blocks.
- **Versatility**: Blends in with a wide range of default solid blocks in Minetest.
- **Efficiency**: Lightweight design ensures minimal performance impact.
- **Economical**: Economical crafting recipes ensures minimal resource usage, spending only one *mese crystal fragment* to produce 8 *mese core* blocks, or one *digiline wire* to produce 8 *digiline core* blocks.
- **Mese Core**: Replaces mesecon wires with visually integrated blocks (e.g., cobblestone, stone).
- **Digiline Core**: Replaces digiline wires with visually integrated blocks for integrating digiline bus into your buildings.
- **Customization**: Perfect for functional building while maintaining a clean look.


## Dependency Requirements

This mod only requires the **mesecons** mod to be installed. Optionally, if you
also want the *digiline core* nodes to be available, you can install the
*digilines* mod.

If the digilines mod is not installed, only Mesecore nodes will be available.
Digicore nodes will not appear in the game.


## Installation

1. Download the latest release from the [Codeberg repository](https://codeberg.org/wogomo/camomese) or from the [Luanti Content DB Page](https://content.luanti.org/packages/mrmane2000/camomese/).
2. Extract the files into your `mods` folder.
3. Enable the mod in your `minetest.conf` or through the in-game settings.


## Possible Applications and Builds:

- Embed mese core cobblestones (`camomese:mesecore_cobble`) to embed mesecon connectivity into a cobblestone wall (for lighting or secret entrances).
- Place a series of *digiline core* cobblestones (`camomese:digicore_cobble`) to embed a digilines bus into your house/base for home automation without taking up too much space.
- Create hidden wiring systems in castles or secret lairs.
- Build futuristic cities with subtly integrated circuitry.
- Automate farms or factories without creating a clutter of horizontal and vertical mesecon wires.

The only limit will be your own imagination.


## Screenshots

![Parking Garage Lighting](./screenshots/parking_garage.png)<br>
_A parking garage with lights that come on when a player enters._

![Outdoor Night Lights With Daylight Cut-Off](./screenshots/outdoor_night_light.png)<br>
_Outdoor lights that come on only at night when a player is nearby._

![Various Mesecore Blocks](./screenshots/various_mesecore_blocks.png)<br>
_Various mese core blocks in their on state._

![Lighting Pillar](./screenshots/lighting_pillar.png)<br>
_Lighting pillar powered via mese core blocks on the floor._

![Digiline Core Cobblestone](./screenshots/digicore_nodes.png)<br>
_Digiline core pine tree blocks used to connect an LCD display to a digiline wire._


## Available Mesecore And Digicore Nodes

Here is a list of *mese core* and *digiline core* nodes that come with this mod:

| Name                    | Default Node                   | Matching Mese Core Node                  | Matching Digiline Core Node              |
| ----------------------- | ------------------------------ | ---------------------------------------- | ---------------------------------------- |
| Acacia Tree             | default:acacia_tree            | camomese:mesecore_acacia_tree            | camomese:digicore_acacia_tree            |
| Acacia Wood             | default:acacia_wood            | camomese:mesecore_acacia_wood            | camomese:digicore_acacia_wood            |
| Aspen Tree              | default:aspen_tree             | camomese:mesecore_aspen_tree             | camomese:digicore_aspen_tree             |
| Aspen Wood              | default:aspen_wood             | camomese:mesecore_aspen_wood             | camomese:digicore_aspen_wood             |
| Cobblestone             | default:cobble                 | camomese:mesecore_cobble                 | camomese:digicore_cobble                 |
| Desert Cobblestone      | default:desert_cobble          | camomese:mesecore_desert_cobble          | camomese:digicore_desert_cobble          |
| Desert Sandstone Block  | default:desert_sandstone_block | camomese:mesecore_desert_sandstone_block | camomese:digicore_desert_sandstone_block |
| Desert Sandstone Brick  | default:desert_sandstone_brick | camomese:mesecore_desert_sandstone_brick | camomese:digicore_desert_sandstone_brick |
| Desert Sandstone        | default:desert_sandstone       | camomese:mesecore_desert_sandstone       | camomese:digicore_desert_sandstone       |
| Desert Stone Block      | default:desert_stone_block     | camomese:mesecore_desert_stone_block     | camomese:digicore_desert_stone_block     |
| Desert Stone Brick      | default:desert_stonebrick      | camomese:mesecore_desert_stonebrick      | camomese:digicore_desert_stonebrick      |
| Desert Stone            | default:desert_stone           | camomese:mesecore_desert_stone           | camomese:digicore_desert_stone           |
| Jungle Tree             | default:jungletree             | camomese:mesecore_jungletree             | camomese:digicore_jungletree             |
| Jungle Wood             | default:junglewood             | camomese:mesecore_junglewood             | camomese:digicore_junglewood             |
| Mossy Cobblestone       | default:mossycobble            | camomese:mesecore_mossycobble            | camomese:digicore_mossycobble            |
| Obsidian Block          | default:obsidian_block         | camomese:mesecore_obsidian_block         | camomese:digicore_obsidian_block         |
| Obsidian Brick          | default:obsidianbrick          | camomese:mesecore_obsidianbrick          | camomese:digicore_obsidianbrick          |
| Obsidian                | default:obsidian               | camomese:mesecore_obsidian               | camomese:digicore_obsidian               |
| Pine Tree               | default:pine_tree              | camomese:mesecore_pine_tree              | camomese:digicore_pine_tree              |
| Pine Wood               | default:pine_wood              | camomese:mesecore_pine_wood              | camomese:digicore_pine_wood              |
| Sandstone Block         | default:sandstone_block        | camomese:mesecore_sandstone_block        | camomese:digicore_sandstone_block        |
| Sandstone Brick         | default:sandstonebrick         | camomese:mesecore_sandstonebrick         | camomese:digicore_sandstonebrick         |
| Sandstone               | default:sandstone              | camomese:mesecore_sandstone              | camomese:digicore_sandstone              |
| Silver Sandstone  Block | default:silver_sandstone_block | camomese:mesecore_silver_sandstone_block | camomese:digicore_silver_sandstone_block |
| Silver Sandstone Brick  | default:silver_sandstone_brick | camomese:mesecore_silver_sandstone_brick | camomese:digicore_silver_sandstone_brick |
| Silver Sandstone        | default:silver_sandstone       | camomese:mesecore_silver_sandstone       | camomese:digicore_silver_sandstone       |
| Stone Block             | default:stone_block            | camomese:mesecore_stone_block            | camomese:digicore_stone_block            |
| Stone Brick             | default:stonebrick             | camomese:mesecore_stonebrick             | camomese:digicore_stonebrick             |
| Stone                   | default:stone                  | camomese:mesecore_stone                  | camomese:digicore_stone                  |
| Apple Tree              | default:tree                   | camomese:mesecore_tree                   | camomese:digicore_tree                   |
| Apple Wood              | default:wood                   | camomese:mesecore_wood                   | camomese:digicore_wood                   |
| Coal Block              | default:coalblock              | camomese:mesecore_coalblock              | camomese:digicore_coalblock              |
| Steel Block             | default:steelblock             | camomese:mesecore_steelblock             | camomese:digicore_steelblock             |
| Copper Block            | default:copperblock            | camomese:mesecore_copperblock            | camomese:digicore_copperblock            |
| Tin Block               | default:tinblock               | camomese:mesecore_tinblock               | camomese:digicore_tinblock               |
| Bronze Block            | default:bronzeblock            | camomese:mesecore_bronzeblock            | camomese:digicore_bronzeblock            |
| Gold Block              | default:goldblock              | camomese:mesecore_goldblock              | camomese:digicore_goldblock              |
| Diamond Block           | default:diamondblock           | camomese:mesecore_diamondblock           | camomese:digicore_diamondblock           |
| Brick                   | default:brick                  | camomese:mesecore_brick                  | camomese:digicore_brick                  |



## Crafting Recipes

### Mese Core Nodes

In order to craft 8 *mese core* blocks, you will need 8 default blocks surrounding a mese crystal fragment.

![Mese Core Cobblestone](./screenshots/mesecore_cobble_recipe.png)<br>
_The recipe for mese core cobblestones._

All mese core node recipes follow the same pattern.

### Digiline Core Nodes

In order to craft 8 digicore blocks, you will need 8 default blocks surrounding a digiline wire.

![Digiline Core Cobblestone](./screenshots/digicore_cobble_recipe.png)<br>
_The recipe for digiline core cobblestones._

All digiline core node recipes follow the same pattern.


### Issues and Improvements

If you find any bugs, discrepancies, or simply have good ideas and suggestions for this mod, please submit them to [the issues page](https://codeberg.org/wogomo/camomese/issues).


## Credits

- Inspired by the creativity of the Luanti community.
- Textures were edited using the power of GIMP!
- Special thanks to TinyPNG for texture optimization assistance.
- Built using Luanti and Lua scripting.

## License

This project is licensed under the MIT License. See `LICENSE` for details.
