assert(not glooptest.tools_module, "Load order conflict!")
glooptest.tools_module = {}

dofile(minetest.get_modpath("glooptest").."/tools_api.lua")
local S = minetest.get_translator("glooptest")

glooptest.tools_module.register_tools("glooptest", "wood", nil, "group:wood", {
	handsaw = {
		makes = true,
		texture = "glooptest_tool_woodhandsaw.png",
		caps = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps = {
				snappy = {times={[2]=1.10, [3]=0.60}, uses=10, maxlevel=1},
				fleshy = {times={[3]=0.90}, uses=10, maxlevel=0}
			},
			damage_groups = {fleshy=2, snappy=3},
		},
		desc = S("Wooden Handsaw"),
	},
	hammer = {
		makes = true,
		texture = "glooptest_tool_woodhammer.png",
		caps = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps = {
				bendy = {times={[2]=1.00, [3]=0.55}, uses=10, maxlevel=1},
				cracky = {times={[3]=1.10}, uses=10, maxlevel=0}
			},
			damage_groups = {fleshy=2, bendy=2, cracky=1},
		},
		desc = S("Wooden Hammer"),
	},
})

glooptest.tools_module.register_tools("glooptest", "stone", nil, "group:stone", {
	handsaw = {
		makes = true,
		texture = "glooptest_tool_stonehandsaw.png",
		caps = {
			full_punch_interval = 1.1,
			max_drop_level = 0,
			groupcaps = {
				snappy = {times={[2]=0.80, [3]=0.40}, uses=20, maxlevel=1},
				fleshy = {times={[3]=0.70}, uses=20, maxlevel=0}
			},
			damage_groups = {fleshy=3, snappy=3},
		},
		desc = S("Stone Handsaw"),
	},
	hammer = {
		makes = true,
		texture = "glooptest_tool_stonehammer.png",
		caps = {
			full_punch_interval = 1.1,
			max_drop_level = 0,
			groupcaps = {
				bendy = {times={[2]=0.90, [3]=0.60}, uses=20, maxlevel=1},
				cracky = {times={[3]=1.00}, uses=20, maxlevel=0}
			},
			damage_groups = {fleshy=2, bendy=2, cracky=1},
		},
		desc = S("Stone Hammer"),
	},
})

glooptest.tools_module.register_tools("glooptest", "steel", nil, "default:steel_ingot", {
	handsaw = {
		makes = true,
		texture = "glooptest_tool_steelhandsaw.png",
		caps = {
			full_punch_interval = 0.9,
			max_drop_level = 0,
			groupcaps = {
				snappy = {times={[1]=1.00, [2]=0.65, [3]=0.25}, uses=30, maxlevel=2},
				fleshy = {times={[2]=1.10, [3]=0.60}, uses=30, maxlevel=1}
			},
			damage_groups = {fleshy=4, snappy=5},
		},
		desc = S("Steel Handsaw")
	},
	hammer = {
		makes = true,
		texture = "glooptest_tool_steelhammer.png",
		caps = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps = {
				bendy = {times={[1]=1.30, [2]=0.80, [3]=0.50}, uses=30, maxlevel=2},
				cracky = {times={[2]=1.80, [3]=0.90}, uses=30, maxlevel=0}
			},
			damage_groups = {fleshy=3, bendy=3, cracky=2},
		},
		desc = S("Steel Hammer"),
	},
})

glooptest.tools_module.register_tools("glooptest", "bronze", nil, "default:bronze_ingot", {
	handsaw = {
		makes = true,
		texture = "glooptest_tool_bronzehandsaw.png",
		caps = {
			full_punch_interval = 0.9,
			max_drop_level = 0,
			groupcaps = {
				snappy = {times={[1]=1.00, [2]=0.65, [3]=0.25}, uses=40, maxlevel=2},
				fleshy = {times={[2]=1.10, [3]=0.60}, uses=40, maxlevel=1}
			},
			damage_groups = {fleshy=4, snappy=5},
		},
		desc = S("Bronze Handsaw"),
	},
	hammer = {
		makes = true,
		texture = "glooptest_tool_bronzehammer.png",
		caps = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps = {
				bendy = {times={[1]=1.30, [2]=0.80, [3]=0.50}, uses=40, maxlevel=2},
				cracky = {times={[2]=1.80, [3]=0.90}, uses=40, maxlevel=0}
			},
			damage_groups = {fleshy=3, bendy=3, cracky=2},
		},
		desc = S("Bronze Hammer"),
	},
})

glooptest.tools_module.register_tools("glooptest", "mese", nil, "default:mese_crystal", {
	handsaw = {
		makes = true,
		texture = "glooptest_tool_mesehandsaw.png",
		caps = {
			full_punch_interval = 0.9,
			max_drop_level = 0,
			groupcaps = {
				snappy = {times={[1]=0.70, [2]=0.40, [3]=0.20}, uses=30, maxlevel=3},
				fleshy = {times={[2]=1.00, [3]=0.55}, uses=30, maxlevel=1}
			},
			damage_groups = {fleshy=5, snappy=6},
		},
		desc = S("Mese Handsaw"),
	},
	hammer = {
		makes = true,
		texture = "glooptest_tool_mesehammer.png",
		caps = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps = {
				bendy = {times={[1]=1.00, [2]=0.60, [3]=0.40}, uses=30, maxlevel=3},
				cracky = {times={[2]=1.70, [3]=0.85}, uses=30, maxlevel=0}
			},
			damage_groups = {fleshy=4, bendy=4, cracky=2},
		},
		desc = S("Mese Hammer"),
	},
})

glooptest.tools_module.register_tools("glooptest", "diamond", nil, "default:diamond", {
	handsaw = {
		makes = true,
		texture = "glooptest_tool_diamondhandsaw.png",
		caps = {
			full_punch_interval = 0.9,
			max_drop_level = 0,
			groupcaps = {
				snappy = {times={[1]=0.60, [2]=0.30, [3]=0.20}, uses=30, maxlevel=3},
				fleshy = {times={[2]=0.90, [3]=0.55}, uses=30, maxlevel=1}
			},
			damage_groups = {fleshy=5, snappy=7},
		},
		desc = S("Diamond Handsaw"),
	},
	hammer = {
		makes = true,
		texture = "glooptest_tool_diamondhammer.png",
		caps = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps = {
				bendy = {times={[1]=0.90, [2]=0.50, [3]=0.40}, uses=30, maxlevel=3},
				cracky = {times={[2]=1.70, [3]=0.85}, uses=30, maxlevel=0}
			},
			damage_groups = {fleshy=4, bendy=5, cracky=2},
		},
		desc = S("Diamond Hammer"),
	},
})

if glooptest.modules["ore"] then
	glooptest.tools_module.register_tools("glooptest", "alatro", nil, "glooptest:alatro_ingot", {
		sword = {
			makes = true,
			texture = "gloopores_tool_alatrosword.png",
			caps = {
				full_punch_interval = 1.0,
				max_drop_level = 0,
				groupcaps={
					fleshy={times={[2]=0.80, [3]=0.60}, uses=40, maxlevel=1},
					snappy={times={[2]=0.80, [3]=0.60}, uses=40, maxlevel=1},
					choppy={times={[3]=0.80}, uses=40, maxlevel=0}
				},
				damage_groups = {fleshy=5},
			},
			desc = S("Alatro Sword"),
		},
		axe = {
			makes = true,
			texture = "gloopores_tool_alatroaxe.png",
			caps = {
				full_punch_interval = 1.0,
				max_drop_level = 0,
				groupcaps = {
					choppy = {times={[2]=0.65, [3]=0.40}, uses=40, maxlevel=1},
					fleshy = {times={[2]=0.65, [3]=0.40}, uses=40, maxlevel=1}
				},
				damage_groups = {fleshy=3},
			},
			desc = S("Alatro Axe"),
		},
		pick = {
			makes = true,
			texture = "gloopores_tool_alatropick.png",
			caps = {
				full_punch_interval = 1.0,
				max_drop_level = 0,
				groupcaps = {
					cracky = {times={[2]=0.65, [3]=0.40}, uses=40, maxlevel=1}
				},
				damage_groups = {fleshy=3},
			},
			desc = S("Alatro Pickaxe"),
		},
		shovel = {
			makes = true,
			texture = "gloopores_tool_alatroshovel.png",
			caps = {
				full_punch_interval = 1.0,
				max_drop_level = 0,
				groupcaps = {
					crumbly = {times={[2]=0.60, [3]=0.35}, uses=40, maxlevel=1}
				},
				damage_groups = {fleshy=3},
			},
			desc = S("Alatro Shovel"),
		},
		handsaw = {
			makes = true,
			texture = "glooptest_tool_alatrohandsaw.png",
			caps = {
				full_punch_interval = 1.0,
				max_drop_level = 0,
				groupcaps = {
					snappy = {times={[2]=0.70, [3]=0.30}, uses=40, maxlevel=1},
					fleshy = {times={[3]=0.65}, uses=40, maxlevel=0}
				},
				damage_groups = {fleshy=3, snappy=3},
			},
			desc = S("Alatro Handsaw"),
		},
		hammer = {
			makes = true,
			texture = "glooptest_tool_alatrohammer.png",
			caps = {
				full_punch_interval = 1.0,
				max_drop_level = 0,
				groupcaps = {
					bendy = {times={[2]=0.85, [3]=0.55}, uses=40, maxlevel=1},
					cracky = {times={[3]=0.95}, uses=40, maxlevel=0}
				},
				damage_groups = {fleshy=2, bendy=2, cracky=1},
			},
			desc = S("Alatro Hammer"),
		},
	})
	glooptest.tools_module.register_tools("glooptest", "arol", nil, "glooptest:arol_ingot", {
		sword = {
			makes = true,
			texture = "gloopores_tool_arolsword.png",
			caps = {
				full_punch_interval = 0.5,
				max_drop_level = 2,
				groupcaps = {
					fleshy = {times={[2]=1.30, [3]=1.10}, uses=300, maxlevel=2},
					snappy = {times={[2]=1.30, [3]=1.10}, uses=300, maxlevel=2},
					choppy = {times={[3]=1.60}, uses=300, maxlevel=1}
				},
				damage_groups = {fleshy=6},
			},
			desc = S("Arol Sword"),
		},
		axe = {
			makes = true,
			texture = "gloopores_tool_arolaxe.png",
			caps = {
				full_punch_interval = 0.5,
				max_drop_level = 2,
				groupcaps = {
					choppy = {times={[1]=3.30, [2]=1.30, [3]=1.00}, uses=300, maxlevel=2},
					fleshy = {times={[2]=1.60, [3]=1.00}, uses=300, maxlevel=2}
				},
				damage_groups = {fleshy=3},
			},
			desc = S("Arol Axe"),
		},
		pick = {
			makes = true,
			texture = "gloopores_tool_arolpick.png",
			caps = {
				full_punch_interval = 0.5,
				max_drop_level = 2,
				groupcaps = {
					cracky = {times={[1]=3.60, [2]=1.90, [3]=1.40}, uses=300, maxlevel=2}
				},
				damage_groups = {fleshy=3},
			},
			desc = S("Arol Pickaxe"),
		},
		shovel = {
			makes = true,
			texture = "gloopores_tool_arolshovel.png",
			caps = {
				full_punch_interval = 0.5,
				max_drop_level = 2,
				groupcaps = {
					crumbly = {times={[1]=2.70, [2]=1.45, [3]=0.85}, uses=300, maxlevel=2}
				},
				damage_groups = {fleshy=3},
			},
			desc = S("Arol Shovel"),
		},
		handsaw = {
			makes = true,
			texture = "glooptest_tool_arolhandsaw.png",
			caps = {
				full_punch_interval = 0.5,
				max_drop_level = 0,
				groupcaps = {
					snappy = {times={[2]=1.00, [3]=0.80}, uses=300, maxlevel=1},
					fleshy = {times={[3]=1.20}, uses=300, maxlevel=0}
				},
				damage_groups = {fleshy=3, snappy=3},
			},
			desc = S("Arol Handsaw"),
		},
		hammer = {
			makes = true,
			texture = "glooptest_tool_arolhammer.png",
			caps = {
				full_punch_interval = 0.5,
				max_drop_level = 0,
				groupcaps = {
					bendy = {times={[2]=1.65, [3]=1.00}, uses=300, maxlevel=1},
					cracky = {times={[3]=1.65}, uses=300, maxlevel=0}
				},
				damage_groups = {fleshy=2, bendy=2, cracky=1},
			},
			desc = S("Arol Hammer"),
		},
	})
end
