local S = core.get_translator("homedecor_roofing")

homedecor_roofing = {}

core.register_node(":homedecor:skylight", {
	description = S("Glass Skylight"),
	drawtype = "raillike",
	tiles = { homedecor.textures.glass.pane },
	wield_image = homedecor.textures.glass.pane,
	inventory_image = "homedecor_skylight_inv.png",
	groups = { snappy = 3, dig_tree = 2 , axey=5},
	is_ground_content = false,
	_mcl_hardness=1.6,
	paramtype = "light",
	_sound_def = {
		key = "node_sound_glass_defaults",
	},
	selection_box = homedecor.nodebox.slab_y(0.1),
	collision_box = homedecor.nodebox.slab_y(0.1),
})

core.register_node(":homedecor:skylight_frosted", {
	description = S("Glass Skylight Frosted"),
	drawtype = "raillike",
	tiles = { "homedecor_skylight_frosted.png" },
	wield_image = "homedecor_skylight_frosted.png",
	inventory_image = "homedecor_skylight_frosted_inv.png",
	use_texture_alpha = "blend",
	groups = { snappy = 3, dig_tree = 2, axey=5},
	is_ground_content = false,
	_mcl_hardness=1.6,
	paramtype = "light",
	_sound_def = {
		key = "node_sound_glass_defaults",
	},
	selection_box = homedecor.nodebox.slab_y(0.1),
	collision_box = homedecor.nodebox.slab_y(0.1),
})

for s, s_loc in pairs({ ["asphalt"] = S("asphalt"), ["terracotta"] = S("terracotta"), ["wood"] = S("wood") }) do
	core.register_node(":homedecor:shingles_"..s, {
		description = S("Shingles (@1)", s_loc),
		drawtype = "raillike",
		tiles = { "homedecor_shingles_"..s..".png" },
		wield_image = "homedecor_shingles_"..s..".png",
		inventory_image = "homedecor_shingles_"..s.."_inv.png",
		paramtype = "light",
		walkable = false,
		groups = { snappy = 3, dig_tree = 2, axey=5},
		is_ground_content = false,
		_mcl_hardness=1.6,
		_sound_def = {
			key = "node_sound_wood_defaults",
		},
		selection_box = homedecor.nodebox.slab_y(0.1),
	})
end

local slope_cbox = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25, 0.5,     0, 0.5},
		{-0.5,     0,     0, 0.5,  0.25, 0.5},
		{-0.5,  0.25,  0.25, 0.5,   0.5, 0.5}
	}
}

local ocorner_cbox = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5,   0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25,  0.25,     0, 0.5},
		{-0.5,     0,     0,     0,  0.25, 0.5},
		{-0.5,  0.25,  0.25, -0.25,   0.5, 0.5}
	}
}

local icorner_cbox = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.25, 0.5}, -- NodeBox5
		{-0.5, -0.5, -0.25, 0.5, 0, 0.5}, -- NodeBox6
		{-0.5, -0.5, -0.5, 0.25, 0, 0.5}, -- NodeBox7
		{-0.5, 0, -0.5, 0, 0.25, 0.5}, -- NodeBox8
		{-0.5, 0, 0, 0.5, 0.25, 0.5}, -- NodeBox9
		{-0.5, 0.25, 0.25, 0.5, 0.5, 0.5}, -- NodeBox10
		{-0.5, 0.25, -0.5, -0.25, 0.5, 0.5}, -- NodeBox11
	}
}

homedecor_roofing.register_outer_corner = function(modname, subname, groups, slope_image, description)
	local tiles = slope_image

	if type(slope_image) ~= "table" then
		tiles = { "homedecor_slope_outer_corner_"..slope_image..".png" }
	end
	groups.axey=5

	core.register_node(":"..modname..":shingle_outer_corner_" .. subname, {
		description = S("@1 (outer corner)", description),
		drawtype = "mesh",
		mesh = "homedecor_slope_outer_corner.obj",
		tiles = tiles,
		paramtype = "light",
		paramtype2 = "facedir",
		selection_box = ocorner_cbox,
		collision_box = ocorner_cbox,
		groups = groups,
		is_ground_content = false,
		_mcl_hardness=1.6,
		on_place = core.rotate_node,
		_sound_def = {
			key = "node_sound_wood_defaults",
		},
	})
end

homedecor_roofing.register_inner_corner = function(modname, subname, groups, slope_image, description)
	local tiles = slope_image

	if type(slope_image) ~= "table" then
		tiles = { "homedecor_slope_outer_corner_"..slope_image..".png" }
	end
	groups.axey=5

	core.register_node(":"..modname..":shingle_inner_corner_" .. subname, {
		description = S("@1 (inner corner)", description),
		drawtype = "mesh",
		mesh = "homedecor_slope_inner_corner.obj",
		tiles = tiles,
		paramtype = "light",
		paramtype2 = "facedir",
		collision_box = icorner_cbox,
		groups = groups,
		is_ground_content = false,
		_mcl_hardness=1.6,
		on_place = core.rotate_node,
		_sound_def = {
			key = "node_sound_wood_defaults",
		},
	})
end

homedecor_roofing.register_slope = function(modname, subname, recipeitem, groups, slope_image, description)
	local tiles = slope_image

	if type(slope_image) ~= "table" then
		tiles = { "homedecor_slope_outer_corner_"..slope_image..".png" }
	end
	groups.axey=5

	core.register_node(":"..modname..":shingle_side_" .. subname, {
		description = description,
		drawtype = "mesh",
		mesh = "homedecor_slope.obj",
		tiles = tiles,
		paramtype = "light",
		paramtype2 = "facedir",
		selection_box = slope_cbox,
		collision_box = slope_cbox,
		use_texture_alpha = "clip",
		groups = groups,
		is_ground_content = false,
		_mcl_hardness=1.6,
		on_place = core.rotate_node,
		_sound_def = {
			key = "node_sound_wood_defaults",
		},
	})

	-- convert between flat shingles and slopes

	core.register_craft({
		output = modname..":shingle_side_"..subname.." 3",
		recipe = {
			{recipeitem, recipeitem, recipeitem}
		}
	})

	core.register_craft({
		output = recipeitem.." 3",
		recipe = {
			{modname..":shingle_side_"..subname, modname..":shingle_side_"..subname, modname..":shingle_side_"..subname},
		}
	})

	-- craft outer corners

	core.register_craft({
		output = modname..":shingle_outer_corner_"..subname.." 3",
		recipe = {
			{ "", recipeitem, "" },
			{ recipeitem, "", recipeitem }
		}
	})

	core.register_craft({
		output = modname..":shingle_outer_corner_"..subname.." 3",
		recipe = {
			{ "", modname..":shingle_side_"..subname, "" },
			{ modname..":shingle_side_"..subname, "", modname..":shingle_side_"..subname },
		}
	})

	-- craft inner corners

	core.register_craft({
		output = modname..":shingle_inner_corner_"..subname.." 3",
		recipe = {
			{recipeitem, recipeitem},
			{"", recipeitem}
		}
	})

	core.register_craft({
		output = modname..":shingle_inner_corner_"..subname.." 3",
		recipe = {
			{modname..":shingle_side_"..subname, modname..":shingle_side_"..subname},
			{"", modname..":shingle_side_"..subname}
		}
	})
	-- convert between flat shingles and inner/outer corners

	core.register_craft({
		type = "shapeless",
		output = recipeitem.." 1",
		recipe = { modname..":shingle_outer_corner_"..subname }
	})

	core.register_craft({
		type = "shapeless",
		output = recipeitem.." 1",
		recipe = { modname..":shingle_inner_corner_"..subname }
	})
end

core.register_craft( {
	output = "homedecor:shingle_side_glass",
	recipe = {
		{ "homedecor:skylight", "homedecor:skylight", "homedecor:skylight" }
	}
})

core.register_craft( {
	output = "homedecor:roof_tile_terracotta 8",
	recipe = {
		{ "homedecor:shingle_outer_corner_terracotta", "homedecor:shingle_outer_corner_terracotta" }
	}
})

core.register_craft( {
	output = "homedecor:roof_tile_terracotta 8",
	recipe = {
		{ "homedecor:shingle_inner_corner_terracotta", "homedecor:shingle_inner_corner_terracotta" }
	}
})

core.register_craft( {
	output = "homedecor:roof_tile_terracotta 8",
	recipe = {
		{ "homedecor:shingle_side_terracotta", "homedecor:shingle_side_terracotta" }
	}
})

core.register_craft({
	type = "fuel",
	recipe = "homedecor:shingle_inner_corner_wood",
	burntime = 30,
})

core.register_craft({
	type = "fuel",
	recipe = "homedecor:shingle_outer_corner_wood",
	burntime = 30,
})

core.register_craft({
	type = "fuel",
	recipe = "homedecor:shingle_side_wood",
	burntime = 30,
})

homedecor_roofing.register_roof = function(modname, subname, groups, slope_image , description)
	homedecor_roofing.register_outer_corner(modname, subname, groups, slope_image, description)
	homedecor_roofing.register_inner_corner(modname, subname, groups, slope_image, description)
end

-- corners

homedecor_roofing.register_roof("homedecor", "wood",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_wood.png" },
	S("Wood Shingles")
)

homedecor_roofing.register_roof("homedecor", "asphalt",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_asphalt.png" },
	S("Asphalt Shingles")
)

homedecor_roofing.register_roof("homedecor", "terracotta",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_terracotta.png" },
	S("Terracotta Shingles")
)

-- register just the slopes

homedecor_roofing.register_slope("homedecor", "wood",
	"homedecor:shingles_wood",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_wood.png" },
	S("Wood Shingles")
)

homedecor_roofing.register_slope("homedecor", "asphalt",
	"homedecor:shingles_asphalt",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_asphalt.png" },
	S("Asphalt Shingles")
)

homedecor_roofing.register_slope("homedecor", "terracotta",
	"homedecor:shingles_terracotta",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_terracotta.png" },
	S("Terracotta Shingles")
)

homedecor_roofing.register_slope("homedecor", "glass",
	"homedecor:shingles_glass",
	{ snappy = 3, dig_tree = 2 },
	{ "homedecor_shingles_glass.png", "homedecor_shingles_wood.png" },
	S("Glass Shingles")
)

local brick_tex = homedecor.textures.brick

homedecor.register("chimney", {
	description = S("Chimney"),
	mesh = "homedecor_chimney.obj",
	tiles = {
		"homedecor_chimney_tb.png",
		brick_tex
	},
	selection_box = homedecor.nodebox.bar_y(0.25),
	groups = {cracky=3, dig_tree = 2},
	_sound_def = {
		key = "node_sound_stone_defaults",
	},
})

-- crafting
core.register_craft({
	output = "homedecor:chimney 2",
	recipe = {
		{ "default:clay_brick", "", "default:clay_brick" },
		{ "default:clay_brick", "", "default:clay_brick" },
		{ "default:clay_brick", "", "default:clay_brick" },
	},
})

core.register_craft( {
        output = "homedecor:skylight 4",
        recipe = {
		{ "homedecor:glass_table_large", "homedecor:glass_table_large" },
		{ "homedecor:glass_table_large", "homedecor:glass_table_large" },
        },
})

core.register_craft( {
	type = "shapeless",
        output = "homedecor:skylight_frosted",
        recipe = {
			"dye:white",
			"homedecor:skylight"
		},
})

core.register_craft({
        type = "cooking",
        output = "homedecor:skylight",
        recipe = "homedecor:skylight_frosted",
})

-- recycling

core.register_craft({
        type = "shapeless",
        output = "vessels:glass_fragments 2",
        recipe = {
		"homedecor:skylight",
		"homedecor:skylight",
		"homedecor:skylight",
		"homedecor:skylight",
		"homedecor:skylight",
		"homedecor:skylight"
	}
})
