-- A geothermal EU generator
-- Using hot lava and water this device can create energy from steam
-- The machine is only producing LV EUs and can thus not drive more advanced equipment
-- The output is a little more than the coal burning generator (max 300EUs)

core.register_alias("geothermal", "technic:geothermal")

local S = technic.getter
local mat = technic.materials

core.register_craft({
	output = 'technic:geothermal',
	recipe = {
		{'technic:granite',          mat.diamond,        'technic:granite'},
		{'basic_materials:copper_wire', 'technic:machine_casing', 'basic_materials:copper_wire'},
		{'technic:granite',          'technic:lv_cable',       'technic:granite'},
	},
	replacements = {
		{"basic_materials:copper_wire", "basic_materials:empty_spool"},
		{"basic_materials:copper_wire", "basic_materials:empty_spool"}
	},
})

core.register_craftitem("technic:geothermal", {
	description = S("Geothermal @1 Generator", S("LV")),
})

local is_water = 1
local is_lava = 2

local check_node_around = function(pos)
	local node = core.get_node(pos)
	if node.name == mat.water_source or node.name == mat.water_flowing then return 1 end
	if node.name == mat.lava_source or node.name == mat.lava_flowing then return 2 end
	return 0
end

local run = function(pos, node)
	local meta             = core.get_meta(pos)
	local water_nodes      = 0
	local lava_nodes       = 0
	local production_level = 0
	local eu_supply        = 0

	-- Correct positioning is water on one side and lava on the other.
	-- The two cannot be adjacent because the lava the turns into obsidian or rock.
	-- To get to 100% production stack the water and lava one extra block down as well:
	--    WGL (W=Water, L=Lava, G=the generator, |=an LV cable)
	--    W|L

	local positions = {
		vector.offset(pos,  1, 0, 0),
		vector.offset(pos,  1, -1, 0),
		vector.offset(pos, -1, 0, 0),
		vector.offset(pos, -1, -1, 0),
		vector.offset(pos,  0, 0, 1),
		vector.offset(pos,  0, -1, 1),
		vector.offset(pos,  0, 0, -1),
		vector.offset(pos,  0, -1, -1),
	}
	for _, p in ipairs(positions) do
		local check = check_node_around(p)
		if check == is_water then water_nodes = water_nodes + 1 end
		if check == is_lava then lava_nodes  = lava_nodes  + 1 end
	end

	if water_nodes == 1 and lava_nodes == 1 then production_level =  25; eu_supply = 50 end
	if water_nodes == 2 and lava_nodes == 1 then production_level =  50; eu_supply = 100 end
	if water_nodes == 1 and lava_nodes == 2 then production_level =  75; eu_supply = 200 end
	if water_nodes == 2 and lava_nodes == 2 then production_level = 100; eu_supply = 300 end

	if production_level > 0 then
		meta:set_int("LV_EU_supply", eu_supply)
	end

	meta:set_string("infotext", S("@1 (@2% Efficiency)",
		S("Geothermal @1 Generator", S("LV")), production_level))

	if production_level > 0 and core.get_node(pos).name == "technic:geothermal" then
		technic.swap_node (pos, "technic:geothermal_active")
		return
	end
	if production_level == 0 then
		technic.swap_node(pos, "technic:geothermal")
		meta:set_int("LV_EU_supply", 0)
	end
end

core.register_node("technic:geothermal", {
	description = S("Geothermal @1 Generator", S("LV")),
	tiles = {"technic_geothermal_top.png", "technic_machine_bottom.png", "technic_geothermal_side.png",
	         "technic_geothermal_side.png", "technic_geothermal_side.png", "technic_geothermal_side.png"},
	groups = {snappy=2, choppy=2, oddly_breakable_by_hand=2,
		technic_machine=1, technic_lv=1, axey=2, handy=1},
	is_ground_content = false,
	_mcl_blast_resistance = 1,
	_mcl_hardness = 0.8,
	paramtype2 = "facedir",
	legacy_facedir_simple = true,
	sounds = technic.sounds.node_sound_wood_defaults(),
	on_construct = function(pos)
		local meta = core.get_meta(pos)
		meta:set_string("infotext", S("Geothermal @1 Generator", S("LV")))
		meta:set_int("LV_EU_supply", 0)
	end,
	technic_run = run,
})

core.register_node("technic:geothermal_active", {
	description = S("Geothermal @1 Generator", S("LV")),
	tiles = {"technic_geothermal_top_active.png", "technic_machine_bottom.png", "technic_geothermal_side.png",
	         "technic_geothermal_side.png", "technic_geothermal_side.png", "technic_geothermal_side.png"},
	paramtype2 = "facedir",
	groups = {snappy=2, choppy=2, oddly_breakable_by_hand=2,
		technic_machine=1, technic_lv=1, not_in_creative_inventory=1, axey=2, handy=1},
	is_ground_content = false,
	_mcl_blast_resistance = 1,
	_mcl_hardness = 0.8,
	legacy_facedir_simple = true,
	sounds = technic.sounds.node_sound_wood_defaults(),
	drop = "technic:geothermal",
	technic_run = run,
})

technic.register_machine("LV", "technic:geothermal",        technic.producer)
technic.register_machine("LV", "technic:geothermal_active", technic.producer)

