---------------------------------------------------------------------------------------
-- decoration and building material
---------------------------------------------------------------------------------------
-- * includes a wagon wheel that can be used as decoration on walls or to build (stationary) wagons
-- * dirt road - those are more natural in small old villages than cobble roads
-- * loam - no, old buildings are usually not built out of clay; loam was used
-- * straw - useful material for roofs
-- * glass pane - an improvement compared to fence posts as windows :-)
---------------------------------------------------------------------------------------

local S = cottages.S

-- can be used to buid real stationary wagons or attached to walls as decoration

--[[ the old version - a flat 2d one
minetest.register_node("cottages:wagon_wheel", {
        description = S("wagon wheel"),
        drawtype = "signlike",
        tiles = {"cottages_wagonwheel.png"}, -- done by VanessaE!
        inventory_image = "cottages_wagonwheel.png",
        wield_image = "cottages_wagonwheel.png",
        paramtype = "light",
        paramtype2 = "wallmounted",

        sunlight_propagates = true,
        walkable = false,
        selection_box = {
                type = "wallmounted",
        },
        groups = {choppy=2,dig_immediate=2,attached_node=1},
        legacy_wallmounted = true,
	is_ground_content = false,
})
--]]

local wagon_wheel_box_side = {-1/2, -1/2, -1/2, -1/2+1/5, 1/2, 1/2}

local rotate_to_bottom = function(b)
    return {b[2], b[1], b[3], b[5], b[4], b[6]}
end

local rotate_to_top = function(b)
    return {b[2], -b[4], b[3], b[5], -b[1], b[6]}
end

minetest.register_node("cottages:wagon_wheel", {
	description = S("wagon wheel"),
	drawtype = "mesh",
	mesh = "cottages_wagonwheel_round_with_axle.obj",
	-- alternate:
	--mesh = "cottages_wagonwheel_voxel.obj",
        tiles = {"cottages_wagonwheel.png"}, -- done by VanessaE!
	--tiles = {"default_junglewood.png"}, -- looks also acceptable
        inventory_image = "cottages_wagonwheel.png",
        wield_image = "cottages_wagonwheel.png",
        paramtype = "light",
        paramtype2 = "wallmounted",
        selection_box = {
            type = "wallmounted",
            wall_side = wagon_wheel_box_side,
            wall_top = rotate_to_top(wagon_wheel_box_side),
            wall_bottom = rotate_to_bottom(wagon_wheel_box_side),
        },
        -- TODO: collision box
        sunlight_propagates = true,
        walkable = false,
        groups = {choppy=2,dig_immediate=2,},
        legacy_wallmounted = true,
	is_ground_content = false,
--	visual_scale = 0.9, -- looks better in parts but also moves the wheel too far away from the wall
})


local wagon_wheel_box_road = {-1, -1/2, -1/2, -1/2+1/5, 1/2, 1/2}

minetest.register_node("cottages:wagon_wheel_road", {
        description = S("wagon wheel on dirt road, sitting half a block behind"),
        drawtype = "mesh",
	mesh = "cottages_wagonwheel_voxel_crimes.obj",
	-- alternate:
	--mesh = "cottages_wagonwheel_voxel.obj",
        tiles = {"cottages_wagonwheel.png"}, -- done by VanessaE!
	--tiles = {"default_junglewood.png"}, -- looks also acceptable
--        inventory_image = "cottages_wagonwheel.png",  -- not set - so you can distinguish it easier from the other one
--        wield_image = "cottages_wagonwheel.png", -- not set - so it will look diffrently in itemframe (perhaps may help sometimes)
        paramtype = "light",
        paramtype2 = "wallmounted",
        selection_box = {
                type = "wallmounted",
                wall_side = wagon_wheel_box_road,
                wall_top = rotate_to_top(wagon_wheel_box_road),
                wall_bottom = rotate_to_bottom(wagon_wheel_box_road),
        },
	-- TODO: collision box
        sunlight_propagates = true,
        walkable = false,
        groups = {choppy=2,dig_immediate=2,},
        legacy_wallmounted = true,
	is_ground_content = false,
--	visual_scale = 0.9,
})



-- bottom or side for a wagon for loading items. for now: use in combination with an itemframe for actual load
minetest.register_node("cottages:wagon_load", {
		description = S("wagon load"),
		drawtype = "nodebox",
                -- top, bottom, side1, side2, inner, outer
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5,    0, -0.5, -0.4, 0.5, 0.5}, -- left
				{  0.4,    0, -0.5,  0.5, 0.5, 0.5}, -- right
--				{ -0.5,    0,  0.4,  0.5, 0.5, 0.5}, -- back
				{ -0.5,    0, -0.5,  0.5, 0.1, 0.5}, -- bottom
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5,    0, -0.5, -0.4, 0.5, 0.5}, -- left
				{  0.4,    0, -0.5,  0.5, 0.5, 0.5}, -- right
--				{ -0.5,    0,  0.4,  0.5, 0.5, 0.5}, -- back
				{ -0.5,    0, -0.5,  0.5, 0.1, 0.5}, -- bottom
			},
		},
		is_ground_content = false,
})


-- people didn't use clay for houses; they did build with loam
minetest.register_node("cottages:loam", {
        description = S("loam"),
        tiles = {"cottages_loam.png"},
	groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
        groups = {crumbly=3},
	sounds = cottages.sounds.dirt,
	is_ground_content = false,
})

-- create stairs if possible
if( minetest.get_modpath("stairs") and stairs and stairs.register_stair_and_slab) then

   stairs.register_stair_and_slab("loam", "cottages:loam",
		{snappy=2,choppy=2,oddly_breakable_by_hand=2},
		{"cottages_loam.png"},
		S("Loam Stairs"),
		S("Loam Slab"),
		cottages.sounds.dirt)

   if( minetest.registered_nodes["default:clay"]) then
      stairs.register_stair_and_slab("clay", "default:clay",
	        {crumbly=3},
		{"cottages_clay.png"},
		S("Clay Stairs"),
		S("Clay Slab"),
		cottages.sounds.dirt)
   end
end


-- straw is a common material for places where animals are kept indoors
-- right now, this block mostly serves as a placeholder
minetest.register_node("cottages:straw_ground", {
        description = S("straw ground for animals"),
        tiles = {cottages.straw_texture,"cottages_loam.png","cottages_loam.png","cottages_loam.png","cottages_loam.png","cottages_loam.png"},
	groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
        groups = {crumbly=3},
        sounds = cottages.sounds.leaves,
	is_ground_content = false,
})


-- note: these houses look good with a single fence pile as window! the glass pane is the version for 'richer' inhabitants
minetest.register_node("cottages:glass_pane", {
		description = S("simple glass pane (centered)"),
		drawtype = "nodebox",
                -- top, bottom, side1, side2, inner, outer
		tiles = {"cottages_glass_pane.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.05,  0.5, 0.5,  0.05},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.05,  0.5, 0.5,  0.05},
			},
		},
		is_ground_content = false,
})


minetest.register_node("cottages:glass_pane_side", {
		description = S("simple glass pane"),
		drawtype = "nodebox",
                -- top, bottom, side1, side2, inner, outer
		tiles = {"cottages_glass_pane.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.40,  0.5, 0.5, -0.50},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.40,  0.5, 0.5, -0.50},
			},
		},
		is_ground_content = false,
})


---------------------------------------------------------------------------------------
-- a very small wooden slab
---------------------------------------------------------------------------------------
minetest.register_node("cottages:wood_flat", {
		description = S("flat wooden planks"),
		drawtype = "nodebox",
                -- top, bottom, side1, side2, inner, outer
		tiles = {"cottages_minimal_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.50,  0.5, -0.5+1/16, 0.50},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.50,  0.5, -0.5+1/16, 0.50},
			},
		},
		is_ground_content = false,
		on_place = minetest.rotate_node,
})

---------------------------------------------------------------------------------------
-- useful for building tents
---------------------------------------------------------------------------------------
minetest.register_node("cottages:wool_tent", {
		description = S("wool for tents"),
		drawtype = "nodebox",
                -- top, bottom, side1, side2, inner, outer
		tiles = {"cottages_wool.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		groups = {snappy=2,choppy=2,oddly_breakable_by_hand=2},
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.50,  0.5, -0.5+1/16, 0.50},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.50,  0.5, -0.5+1/16, 0.50},
			},
		},
		is_ground_content = false,
		on_place = minetest.rotate_node,
})

-- a fallback for cases in which there is no wool
if( not( minetest.registered_nodes["wool:white"])) then
	minetest.register_node("cottages:wool", {
		description = "Wool",
		tiles = {"cottages_wool.png"},
		is_ground_content = false,
		groups = {snappy=2,choppy=2,oddly_breakable_by_hand=3,flammable=3,wool=1},
	})
else
	minetest.register_alias("cottages:wool", "wool:white")
end


---------------------------------------------------------------------------------------
-- crafting receipes
---------------------------------------------------------------------------------------
minetest.register_craft({
	output = "cottages:wagon_wheel 3",
	recipe = {
		{cottages.craftitem_iron, cottages.craftitem_stick,       cottages.craftitem_iron },
		{cottages.craftitem_stick,     cottages.craftitem_steel, cottages.craftitem_stick },
		{cottages.craftitem_iron, cottages.craftitem_stick,       cottages.craftitem_iron }
	}
})

-- craft the special wheel with the offset for the dirt roads
minetest.register_craft({
	output = "cottages:wagon_wheel_road",
	recipe = {{"cottages:wagon_wheel"}},
})

minetest.register_craft({
	output = "cottages:wagon_wheel",
	recipe = {{"cottages:wagon_wheel_road"}},
})


if(minetest.get_modpath('moreblocks')) then
	minetest.register_craft({
		output = "cottages:wagon_load",
		recipe = {{"moreblocks:panel_wood_1", "moreblocks:slab_wood_1", "moreblocks:panel_wood_1"}},
	})
else
	minetest.register_craft({
		output = "cottages:wagon_load 4",
		recipe = {{"stairs:slab_wood", "",                 "stairs:slab_wood"},
		          {"",                 "stairs:slab_wood", ""},
		          {"",                 "default:stick",    ""}},
	})
end


minetest.register_craft({
	output = "cottages:loam 4",
	recipe = {
		{cottages.craftitem_sand},
		{cottages.craftitem_clay}
	}
})

minetest.register_craft({
	output = "cottages:straw_ground 2",
	recipe = {
		{"cottages:straw_mat" },
		{"cottages:loam"}
	}
})

minetest.register_craft({
	output = "cottages:glass_pane 4",
	recipe = {
		{cottages.craftitem_stick, cottages.craftitem_stick, cottages.craftitem_stick },
		{cottages.craftitem_stick, cottages.craftitem_glass, cottages.craftitem_stick },
		{cottages.craftitem_stick, cottages.craftitem_stick, cottages.craftitem_stick }
	}
})

minetest.register_craft({
	output = "cottages:glass_pane_side",
	recipe = {
		{"cottages:glass_pane"},
	}
})

minetest.register_craft({
	output = "cottages:glass_pane",
	recipe = {
		{"cottages:glass_pane_side"},
	}
})

minetest.register_craft({
	output = "cottages:wood_flat 16",
	recipe = {
		{cottages.craftitem_stick, "farming:string",cottages.craftitem_stick },
		{cottages.craftitem_stick, "",              cottages.craftitem_stick },
	}
})

minetest.register_craft({
	output = "cottages:wool_tent 2",
	recipe = {
		{"farming:string", "farming:string"},
		{"",cottages.craftitem_stick}
	}
})

minetest.register_craft({
	output = "cottages:wool",
	recipe = {
		{"cottages:wool_tent", "cottages:wool_tent"}
	}
})
