-- Home Decor mod by VanessaE
--
-- Mostly my own code, with bits and pieces lifted from Minetest's default
-- lua files and from ironzorg's flowers mod.  Many thanks to GloopMaster
-- for helping me figure out the inventories used in the nightstands/dressers.
--
-- The code for ovens, nightstands, refrigerators are basically modified
-- copies of the code for chests and furnaces.

local S = core.get_translator("homedecor_misc")

homedecor_misc = {}

local wool_black, wool_grey = homedecor.textures.wool.black, homedecor.textures.wool.grey
local wood_tex = homedecor.textures.wood.apple.planks

homedecor.register("ceiling_paint", {
	description = S("Textured Ceiling Paint"),
	drawtype = 'signlike',
	tiles = { 'homedecor_ceiling_paint.png' },
	inventory_image = 'homedecor_ceiling_paint_roller.png',
	wield_image = 'homedecor_ceiling_paint_roller.png',
	walkable = false,
	groups = { snappy = 3 },
	_sound_def = {
		key = "node_sound_leaves_defaults",
	},
	selection_box = { type = "wallmounted" },
})

homedecor.register("ceiling_tile", {
	description = S("Drop-Ceiling Tile"),
	drawtype = 'signlike',
	tiles = { 'homedecor_ceiling_tile.png' },
	wield_image = 'homedecor_ceiling_tile.png',
	inventory_image = 'homedecor_ceiling_tile.png',
	walkable = false,
	groups = { snappy = 3 },
	_sound_def = {
		key = "node_sound_leaves_defaults",
	},
	selection_box = { type = "wallmounted" },
})

local rug_types = {
	{ "small", S("small"), "homedecor_small_rug.obj" },
	{ "large", S("large"), homedecor.box.slab_y(0.0625) },
	{ "persian", S("persian"), homedecor.box.slab_y(0.0625) },
}

for _, rt in ipairs(rug_types) do
	local s, desc, m = unpack(rt)

	local mesh = m
	local nodebox = nil
	local tiles = { "homedecor_rug_"..s..".png", wool_grey }

	if type(m) == "table" then
		mesh = nil
		nodebox = {
			type = "fixed",
			fixed = m
		}
		tiles = {
			"homedecor_rug_"..s..".png",
			wool_grey,
			"homedecor_rug_"..s..".png"
		}
	end

	homedecor.register("rug_"..s, {
		description = S("Rug (@1)", desc),
		mesh = mesh,
		tiles = tiles,
		node_box = nodebox,
		paramtype2 = "wallmounted",
		walkable = false,
		groups = {snappy = 3},
		_sound_def = {
			key = "node_sound_leaves_defaults",
		},
		selection_box = { type = "wallmounted" },
	})
end

local pot_colors = {
	{ "black", S("black") },
	{ "green", S("green") },
	{ "terracotta", S("terracotta") },
}

for _, pot in ipairs(pot_colors) do
	local p, desc = unpack(pot)

	homedecor.register("flower_pot_"..p, {
		description = S("Flower Pot (@1)", desc),
		mesh = "homedecor_flowerpot.obj",
		tiles = {
			"homedecor_flower_pot_"..p..".png",
			{ name = default and "default_dirt.png" or wood_tex, color = 0xff505050 },
		},
		groups = { snappy = 3, potting_soil=1 },
		_sound_def = {
			key = "node_sound_stone_defaults",
		},
	})
end

if core.get_modpath("flowers") then
	local flowers_list = {
		{ S("Rose"),				"rose",				"flowers:rose" },
		{ S("Tulip"),				"tulip",			"flowers:tulip" },
		{ S("Yellow Dandelion"),	"dandelion_yellow",	"flowers:dandelion_yellow" },
		{ S("White Dandelion"), 	"dandelion_white",	"flowers:dandelion_white" },
		{ S("Blue Geranium"),		"geranium",			"flowers:geranium" },
		{ S("Viola"),				"viola",			"flowers:viola" },
		{ S("Cactus"),				"cactus",			"default:cactus" },
		{ S("Bonsai"),				"bonsai",			"default:sapling" }
	}

	for _, f in ipairs(flowers_list) do
		local flowerdesc, flower, craftwith = unpack(f)

		homedecor.register("potted_"..flower, {
			description = S("Potted flower (@1)", flowerdesc),
			mesh = "homedecor_potted_plant.obj",
			tiles = {
				"homedecor_flower_pot_terracotta.png",
				{ name = "default_dirt.png", color = 0xff303030 },
				"flowers_"..flower..".png"
			},
			walkable = false,
			use_texture_alpha = "clip",
			groups = {snappy = 3},
			_sound_def = {
				key = "node_sound_glass_defaults",
			},
			selection_box = {
				type = "fixed",
				fixed = { -0.2, -0.5, -0.2, 0.2, 0.3, 0.2 }
			}
		})

		core.register_craft({
			type = "shapeless",
			output = "homedecor:potted_"..flower,
			recipe = { craftwith, "homedecor:flower_pot_small" }
		})

		core.register_alias("flowers:flower_"..flower.."_pot", "homedecor:potted_"..flower)
		core.register_alias("flowers:potted_"..flower, "homedecor:potted_"..flower)
		core.register_alias("flowers:flower_pot", "homedecor:flower_pot_small")
	end
end

homedecor.register("pole_brass", {
	description = S("Brass Pole"),
	mesh = "homedecor_round_pole.obj",
	tiles = {"homedecor_generic_metal_brass.png^homedecor_generic_metal_lines_overlay.png",},
	inventory_image = "homedecor_pole_brass_inv.png",
	wield_image = "homedecor_pole_brass_inv.png",
	selection_box = {
		type = "fixed",
		fixed = { -0.125, -0.5, -0.125, 0.125, 0.5, 0.125 },
	},
	collision_box = {
		type = "fixed",
		fixed = { -0.125, -0.5, -0.125, 0.125, 0.5, 0.125 },
	},
	groups = {snappy=3},
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
	check_for_pole = true
})

homedecor.register("pole_wrought_iron", {
    description = S("Wrought Iron Pole"),
    tiles = { "homedecor_generic_metal_wrought_iron.png^homedecor_generic_metal_lines_overlay.png" },
    inventory_image = "homedecor_pole_wrought_iron_inv.png",
    wield_image = "homedecor_pole_wrought_iron_inv.png",
    selection_box = {
            type = "fixed",
            fixed = {-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625}
    },
	node_box = {
		type = "fixed",
                fixed = {-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625}
	},
    groups = {snappy=3},
    _sound_def = {
		key = "node_sound_wood_defaults",
	},
})

local ft_cbox = {
	type = "fixed",
	fixed = { -0.5, -0.5, -0.375, 0.5, 0.3125, 0.375 }
}

homedecor.register("fishtank", {
	description = S("Fishtank"),
	mesh = "homedecor_fishtank.obj",
	tiles = {
		{ name = "homedecor_generic_plastic.png", color = homedecor.color_black },
		"homedecor_fishtank_filter.png",
		"homedecor_fishtank_fishes.png",
		"homedecor_fishtank_gravel.png",
		"homedecor_fishtank_water_top.png",
		"homedecor_fishtank_sides.png",
	},
	use_texture_alpha = "blend",
	selection_box = ft_cbox,
	collision_box = ft_cbox,
	groups = {cracky=3,oddly_breakable_by_hand=3},
	_sound_def = {
		key = "node_sound_glass_defaults",
	},
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		core.set_node(pos, {name = "homedecor:fishtank_lighted", param2 = node.param2})
		return itemstack
	end
})

homedecor.register("fishtank_lighted", {
	description = S("Fishtank (lighted)"),
	mesh = "homedecor_fishtank.obj",
	tiles = {
		{ name = "homedecor_generic_plastic.png", color = homedecor.color_black },
		"homedecor_fishtank_filter.png",
		"homedecor_fishtank_fishes_lighted.png",
		"homedecor_fishtank_gravel_lighted.png",
		"homedecor_fishtank_water_top_lighted.png",
		"homedecor_fishtank_sides_lighted.png",
	},
	light_source = core.LIGHT_MAX-4,
	use_texture_alpha = "blend",
	selection_box = ft_cbox,
	collision_box = ft_cbox,
	groups = {cracky=3,oddly_breakable_by_hand=3,not_in_creative_inventory=1},
	_sound_def = {
		key = "node_sound_glass_defaults",
	},
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		core.set_node(pos, {name = "homedecor:fishtank", param2 = node.param2})
		return itemstack
	end,
	drop = "homedecor:fishtank",
})

homedecor.register("cardboard_box_big", {
	description = S("Cardboard box (big)"),
	tiles = {
		'homedecor_cardbox_big_tb.png',
		'homedecor_cardbox_big_tb.png',
		'homedecor_cardbox_big_sides.png',
	},
	use_texture_alpha = "clip",
	groups = { snappy = 3 },
	infotext=S("Cardboard box"),
	inventory = {
		size=24,
	},
})

homedecor.register("cardboard_box", {
	description = S("Cardboard box"),
	tiles = {
		'homedecor_cardbox_tb.png',
		'homedecor_cardbox_tb.png',
		'homedecor_cardbox_sides.png',
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.3125, -0.5, -0.3125, 0.3125, 0, 0.3125},
		}
	},
	use_texture_alpha = "clip",
	groups = { snappy = 3 },
	infotext=S("Cardboard box"),
	inventory = {
		size=8,
	},
})

homedecor.register("dvd_cd_cabinet", {
	description = S("DVD/CD cabinet"),
	mesh = "homedecor_dvd_cabinet.obj",
	tiles = {
		wood_tex,
		"homedecor_dvdcd_cabinet_front.png",
		"homedecor_dvdcd_cabinet_back.png"
	},
	selection_box = homedecor.nodebox.slab_z(-0.5),
	groups = {choppy=2,oddly_breakable_by_hand=2},
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
	crafts = {
		{
			type = "shapeless",
			recipe = {
				"homedecor:dvd_player", "homedecor:kitchen_cabinet_colorable"
			}
		}
	}
})

local pooltable_cbox = {
	type = "fixed",
	fixed = { -0.5, -0.5, -0.5, 0.5, 0.3125, 1.5 }
}

homedecor.register("pool_table", {
	mesh = "homedecor_pool_table.obj",
	tiles = {
		"homedecor_pool_table_cue.png",
		"homedecor_pool_table_baize.png",
		"homedecor_pool_table_pockets.png",
		"homedecor_pool_table_balls.png",
		homedecor.lux_wood,
	},
	description = S("Pool Table"),
	inventory_image = "homedecor_pool_table_inv.png",
	groups = {snappy=3},
	selection_box = pooltable_cbox,
	collision_box = pooltable_cbox,
	expand = { forward="placeholder" },
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
	on_rotate = core.get_modpath("screwdriver") and screwdriver.disallow or nil,
})

core.register_alias("homedecor:pool_table_2", "air")

local piano_cbox = {
	type = "fixed",
	fixed = { -0.5, -0.5, -0.125, 1.5, 0.5, 0.5 }
}

homedecor.register("piano", {
	mesh = "homedecor_piano.obj",
	tiles = {
		{ name = "homedecor_generic_wood_luxury.png", color = homedecor.color_black },
		"homedecor_piano_keys.png",
		"homedecor_generic_metal_brass.png",
	},
	inventory_image = "homedecor_piano_inv.png",
	description = S("Piano"),
	groups = { snappy = 3 },
	selection_box = piano_cbox,
	collision_box = piano_cbox,
	expand = { right="placeholder" },
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
	on_rotate = core.get_modpath("screwdriver") and screwdriver.disallow or nil,
})

core.register_alias("homedecor:piano_left", "homedecor:piano")
core.register_alias("homedecor:piano_right", "air")

local tr_cbox = {
	type = "fixed",
	fixed = { -0.3125, -0.5, -0.1875, 0.3125, 0.125, 0.1875 }
}

homedecor.register("trophy", {
	description = S("Trophy"),
	mesh = "homedecor_trophy.obj",
	tiles = {
		wood_tex,
		"homedecor_generic_metal_gold.png"
	},
	inventory_image = "homedecor_trophy_inv.png",
	groups = { snappy=3 },
	walkable = false,
	selection_box = tr_cbox,
})

local sb_cbox = {
	type = "fixed",
	fixed = { -0.4, -0.5, -0.5, 0.4, 0.375, 0.5 }
}

homedecor.register("sportbench", {
	description = S("Sport bench"),
	mesh = "homedecor_sport_bench.obj",
	tiles = {
		"homedecor_generic_metal_wrought_iron.png",
		"homedecor_generic_metal_bright.png",
		{ name = "homedecor_generic_metal.png", color = homedecor.color_black },
		wool_black
	},
	inventory_image = "homedecor_sport_bench_inv.png",
	groups = { snappy=3 },
	selection_box = sb_cbox,
	walkable = false,
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
})

local skate_cbox = {
	type = "fixed",
	fixed = { -0.5, -0.5, -0.15, 0.5, -0.3, 0.15 }
}

homedecor.register("skateboard", {
	drawtype = "mesh",
	mesh = "homedecor_skateboard.obj",
	tiles = { "homedecor_skateboard.png" },
	inventory_image = "homedecor_skateboard_inv.png",
	description = S("Skateboard"),
	use_texture_alpha = "clip",
	groups = {snappy=3},
	selection_box = skate_cbox,
	walkable = false,
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
	on_place = core.rotate_node
})

homedecor_misc.banister_materials = {
	{
		"wood",
		S("wood"),
		wood_tex,
		wood_tex,
		"group:wood",
		"group:stick",
		"",
		""
	},
	{
		"white_dark",
		S("dark topped"),
		homedecor.white_wood,
		homedecor.dark_wood,
		"group:wood",
		"group:stick",
		"dye:brown",
		"dye:white"
	},
	{
		"brass",
		S("brass"),
		homedecor.white_wood,
		"homedecor_generic_metal_brass.png",
		"technic:brass_ingot",
		"group:stick",
		"",
		"dye:white"
	},
	{
		"wrought_iron",
		S("wrought iron"),
		"homedecor_generic_metal_wrought_iron.png",
		"homedecor_generic_metal_wrought_iron.png",
		"homedecor:pole_wrought_iron",
		"homedecor:pole_wrought_iron",
		"",
		""
	}
}

for _, side in ipairs({"diagonal_left", "diagonal_right", "horizontal"}) do

	local sidedesc = side:match("^diagonal") and S("diagonal") or S("horizontal")

	for _, mat in ipairs(homedecor_misc.banister_materials) do

		local name, matdesc, tile1, tile2 = unpack(mat)
		local nodename = "banister_"..name.."_"..side

		local cbox = {
			type = "fixed",
			fixed = { -9/16, -3/16, 5/16, 9/16, 24/16, 8/16 }
		}

		if side == "horizontal" then
			cbox = {
				type = "fixed",
				fixed = { -8/16, -8/16, 5/16, 8/16, 8/16, 8/16 }
			}
		end

		local def = {
			description = S("Banister for Stairs (@1, @2)", matdesc, sidedesc),
			mesh = "homedecor_banister_"..side..".obj",
			tiles = {
				tile1,
				tile2,
			},
			inventory_image = "homedecor_banister_"..name.."_inv.png",
			selection_box = cbox,
			collision_box = cbox,
			groups = { snappy = 3},
			on_place = homedecor.place_banister,
			drop = "homedecor:banister_"..name.."_horizontal",
		}

		if side ~= "horizontal" then
			def.groups.not_in_creative_inventory = 1
		end

		if name == "wood" then
			def.palette = "unifieddyes_palette_greys.png"
			def.airbrush_replacement_node = "homedecor:banister_wood_"..side.."_grey"
			def.groups.ud_param2_colorable = 1
			def.paramtype2 = "colorfacedir"
			def.on_dig = unifieddyes.on_dig
		end
		homedecor.register(nodename, def)

		if name == "wood" then
			local nn = "homedecor:"..nodename
			local def2 = table.copy(core.registered_items[nn])
			def2.tiles = {
				homedecor.white_wood,
				homedecor.white_wood
			}
			def2.inventory_image = "homedecor_banister_wood_colored_inv.png"
			def2.groups.not_in_creative_inventory = 1

			unifieddyes.generate_split_palette_nodes(nn, def2, "homedecor:banister_"..name.."_horizontal")
		end
	end
end

homedecor.register("spiral_staircase", {
	description = S("Spiral Staircase"),
	mesh = "homedecor_spiral_staircase.obj",
	wield_scale = { x=0.4, y=0.4, z=0.4 },
	tiles = {
		"homedecor_generic_metal_wrought_iron.png",
	},
	selection_box = {
		type = "fixed",
		fixed = { -1.5, -0.5, -1.5, 0.5, 2.5, 0.5 }
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5625, -0.5, -0.5625, -0.4375, 2.5, -0.4375}, -- NodeBox9
			{-0.5, -0.5, -0.5, 0.5, -0.4375, 0}, -- NodeBox14
			{-0.5, -0.125, -0.5, -0.25, -0.0625, 0.5}, -- NodeBox15
			{-0.25, -0.125, -0.0625, 0, -0.0625, 0.5}, -- NodeBox16
			{-1, 0.25, -0.5, -0.5, 0.3125, 0.5}, -- NodeBox17
			{-1.5, 0.625, -0.5, -0.5, 0.6875, -0.25}, -- NodeBox18
			{-1.5, 0.625, -0.25, -0.9375, 0.6875, 0}, -- NodeBox19
			{-1.5, 1, -1, -0.5, 1.0625, -0.5}, -- NodeBox20
			{-0.75, 1.375, -1.5, -0.5, 1.4375, -0.5}, -- NodeBox21
			{-1, 1.375, -1.5, -0.75, 1.4375, -1}, -- NodeBox22
			{-0.5, 1.75, -1.5, 0.0625, 1.8125, -0.5}, -- NodeBox23
			{-0.5, 2.125, -0.8125, 0.5, 2.1875, -0.5}, -- NodeBox24
			{-0.0625, 2.125, -1.0625, 0.5, 2.1875, -0.75}, -- NodeBox25
			{-1.5, -0.125, 0.4375, 0.5, 1.625, 0.5}, -- NodeBox26
			{-1.5, 1.5625, -1.5, -1.4375, 2.875, 0.5}, -- NodeBox27
			{-1.5, 1.75, -1.5, 0.5, 3.3125, -1.4375}, -- NodeBox28
			{0.4375, -0.5, -0.5, 0.5, 0.875, 0.5}, -- NodeBox29
			{0.4375, 2.125, -1.5, 0.5, 3.3125, 0.5}, -- NodeBox30
		}
	},
	groups = {cracky = 1},
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
	on_rotate = core.get_modpath("screwdriver") and screwdriver.rotate_simple or nil,
	after_place_node = function(pos, placer, itemstack, pointed_thing)
		local fdir = core.dir_to_facedir(placer:get_look_dir())
		local leftx =  homedecor.fdir_to_left[fdir+1][1]
		local leftz =  homedecor.fdir_to_left[fdir+1][2]
		local revx  = -homedecor.fdir_to_fwd[fdir+1][1]
		local revz  = -homedecor.fdir_to_fwd[fdir+1][2]

		local corner1 = { x = pos.x + leftx + revx, y = pos.y, z = pos.z + leftz + revz}
		local corner2 = { x = pos.x, y = pos.y + 2, z = pos.z }

		local minp = { x = math.min(corner1.x, corner2.x),
		               y = math.min(corner1.y, corner2.y),
		               z = math.min(corner1.z, corner2.z) }

		local maxp = { x = math.max(corner1.x, corner2.x),
		               y = math.max(corner1.y, corner2.y),
		               z = math.max(corner1.z, corner2.z) }

		if #core.find_nodes_in_area(minp, maxp, "air") < 11 then
			core.set_node(pos, {name = "air"})
			core.chat_send_player(placer:get_player_name(), S("not enough space"))
			return true
		end

		local belownode = core.get_node({ x = pos.x, y = pos.y - 1, z = pos.z })

		if belownode and belownode.name == "homedecor:spiral_staircase" then
			local newpos = { x = pos.x, y = pos.y + 2, z = pos.z }
			core.set_node(pos, { name = "air" })
			core.set_node(newpos, { name = "homedecor:spiral_staircase", param2 = belownode.param2 })
		end
	end
})

core.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack, pointed_thing)
	local belownode = core.get_node({ x = pos.x, y = pos.y - 1, z = pos.z })

	if newnode.name ~= "homedecor:spiral_staircase"
	  and belownode
	  and belownode.name == "homedecor:spiral_staircase" then
		core.set_node(pos, { name = "air" })

		local newpos = { x = pos.x, y = pos.y + 2, z = pos.z }
		local checknode = core.get_node(newpos)

		if checknode and checknode.name == "air" then
			local fdir = core.dir_to_facedir(placer:get_look_dir())
			core.set_node(newpos, { name = newnode.name, param2 = fdir })
		else
			return true
		end
	end
end)

core.register_node(":homedecor:tatami_mat", {
	tiles = {
		"homedecor_tatami.png",
		"homedecor_tatami.png",
		"homedecor_tatami.png",
		"homedecor_tatami.png",
		"homedecor_tatami.png",
		"homedecor_tatami.png"
	},
	description = S("Japanese tatami"),
	drawtype = "nodebox",
	paramtype = "light",
	groups = {snappy=3, axey=5},
	is_ground_content = false,
	_mcl_hardness=1.6,
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5},
		}
	}
})

homedecor.register("dartboard", {
	description = S("Dartboard"),
	mesh = "homedecor_dartboard.obj",
	tiles = { "homedecor_dartboard.png" },
	inventory_image = "homedecor_dartboard_inv.png",
	wield_image = "homedecor_dartboard_inv.png",
	paramtype2 = "wallmounted",
	walkable = false,
	selection_box = {
		type = "wallmounted",
	},
	groups = {choppy=2,dig_immediate=2,attached_node=1},
	legacy_wallmounted = true,
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
})

-- crafting

-- Crafting for homedecor mod (includes folding) by Vanessa Ezekowitz
--
-- Mostly my own code; overall template borrowed from game default

core.register_craft( {
	output = "homedecor:flower_pot_terracotta",
	recipe = {
		{ "homedecor:roof_tile_terracotta", homedecor.materials.dirt, "homedecor:roof_tile_terracotta" },
		{ "homedecor:roof_tile_terracotta", "homedecor:roof_tile_terracotta", "homedecor:roof_tile_terracotta" },
	},
})

core.register_craft( {
	output = "homedecor:flower_pot_green",
	recipe = {
		{ "", "dye:dark_green", "" },
		{ "basic_materials:plastic_sheet", homedecor.materials.dirt, "basic_materials:plastic_sheet" },
		{ "basic_materials:plastic_sheet", "basic_materials:plastic_sheet", "basic_materials:plastic_sheet" },
	},
})

core.register_craft( {
	output = "homedecor:flower_pot_black",
	recipe = {
		{ homedecor.materials.dye_black, homedecor.materials.dye_black, homedecor.materials.dye_black },
		{ "basic_materials:plastic_sheet", homedecor.materials.dirt, "basic_materials:plastic_sheet" },
		{ "basic_materials:plastic_sheet", "basic_materials:plastic_sheet", "basic_materials:plastic_sheet" },
	},
})

core.register_craft( {
	type = "shapeless",
	output = "homedecor:ceiling_paint 20",
	recipe = {
		homedecor.materials.dye_white,
		homedecor.materials.dye_white,
		homedecor.materials.sand,
		homedecor.materials.water_bucket,
	},
	replacements = { { homedecor.materials.water_bucket,homedecor.materials.empty_bucket } }
})

core.register_craft( {
	output = "homedecor:ceiling_tile 10",
	recipe = {
		{ "", homedecor.materials.dye_white, "" },
		{ homedecor.materials.steel_ingot, homedecor.materials.stone, homedecor.materials.steel_ingot },
	},
})

core.register_craft( {
	output = "homedecor:drawer_small",
	recipe = {
		{ "group:wood", homedecor.materials.steel_ingot, "group:wood" },
	},
})

core.register_craft({
	type = "fuel",
	recipe = "homedecor:drawer_small",
	burntime = 30,
})

-- vertical poles/lampposts

core.register_craft( {
	output = "homedecor:pole_brass 4",
	recipe = {
		{ "", "basic_materials:brass_ingot", "" },
		{ "", "basic_materials:brass_ingot", "" },
		{ "", "basic_materials:brass_ingot", "" }
	},
})

core.register_craft( {
	output = "homedecor:pole_wrought_iron 4",
	recipe = {
		{ homedecor.materials.iron_lump, },
		{ homedecor.materials.iron_lump, },
		{ homedecor.materials.iron_lump, },
	},
})

-- ===========================================================
-- Recipes that require materials from wool (cotton alternate)

core.register_craft( {
	type = "shapeless",
	output = "homedecor:rug_small 8",
	recipe = {
			"wool:red",
			"wool:yellow",
			"wool:blue",
			"wool:black"
	},
})

core.register_craft( {
	output = "homedecor:rug_persian 8",
	recipe = {
		{ "", "wool:yellow", "" },
		{ "wool:red", "wool:blue", "wool:red" },
		{ "", "wool:yellow", "" }
	},
})

-- cotton versions:

core.register_craft( {
	type = "shapeless",
	output = "homedecor:rug_small 8",
	recipe = {
		"cotton:red",
		"cotton:yellow",
		"cotton:blue",
		"cotton:black"
	},
})

core.register_craft( {
	output = "homedecor:rug_persian 8",
	recipe = {
		{ "", "cotton:yellow", "" },
		{ "cotton:red", "cotton:blue", "cotton:red" },
		{ "", "cotton:yellow", "" }
	},
})

-- fuel recipes for same

core.register_craft({
	type = "fuel",
	recipe = "homedecor:rug_small",
	burntime = 30,
})

core.register_craft( {
	type = "shapeless",
	output = "homedecor:rug_large 2",
	recipe = {
		"homedecor:rug_small",
		"homedecor:rug_small",
	},
})

core.register_craft({
	type = "fuel",
	recipe = "homedecor:rug_large",
	burntime = 30,
})

core.register_craft({
	type = "fuel",
	recipe = "homedecor:rug_persian",
	burntime = 30,
})

-- more misc stuff here

core.register_craft({
	output = "homedecor:fishtank",
	recipe = {
		{ "basic_materials:plastic_sheet", "homedecor:glowlight_small_cube", "basic_materials:plastic_sheet" },
		{ homedecor.materials.glass_block, homedecor.materials.water_bucket, homedecor.materials.glass_block },
		{ homedecor.materials.glass_block, "building_blocks:gravel_spread", homedecor.materials.glass_block },
	},
	replacements = { {homedecor.materials.water_bucket, homedecor.materials.empty_bucket} }
})

core.register_craft({
	output = "homedecor:cardboard_box 2",
	recipe = {
		{ homedecor.materials.paper, "", homedecor.materials.paper },
		{ homedecor.materials.paper, homedecor.materials.paper, homedecor.materials.paper },
	},
})

core.register_craft({
	output = "homedecor:cardboard_box_big 2",
	recipe = {
		{ homedecor.materials.paper, "", homedecor.materials.paper },
		{ homedecor.materials.paper, "", homedecor.materials.paper },
		{ homedecor.materials.paper, homedecor.materials.paper, homedecor.materials.paper },
	},
})

-- japanese walls and mat

core.register_craft( {
	output = "homedecor:japanese_wall_top",
	recipe = {
		{"group:stick", homedecor.materials.paper},
		{ homedecor.materials.paper, "group:stick"},
		{"group:stick", homedecor.materials.paper}
	},
})

core.register_craft( {
	output = "homedecor:japanese_wall_top",
	recipe = {
		{homedecor.materials.paper, "group:stick"},
		{"group:stick", homedecor.materials.paper},
		{homedecor.materials.paper, "group:stick"}
	},
})

core.register_craft( {
	output = "homedecor:japanese_wall_middle",
	recipe = {
		{"homedecor:japanese_wall_top"}
	},
})

core.register_craft( {
	output = "homedecor:japanese_wall_bottom",
	recipe = {
		{"homedecor:japanese_wall_middle"}
	},
})

core.register_craft( {
	output = "homedecor:japanese_wall_top",
	recipe = {
		{"homedecor:japanese_wall_bottom"}
	},
})

core.register_craft( {
	output = "homedecor:tatami_mat",
	recipe = {
		{"farming:wheat", "farming:wheat", "farming:wheat"}
	},
})

core.register_craft( {
	output = "homedecor:pool_table",
	recipe = {
		{ "wool:dark_green", "wool:dark_green", "wool:dark_green" },
		{ "building_blocks:hardwood", "building_blocks:hardwood", "building_blocks:hardwood" },
		{ "building_blocks:slab_hardwood", "", "building_blocks:slab_hardwood" }
	},
})

core.register_craft({
	output = "homedecor:dartboard",
	recipe = {
		{"dye:black", "basic_materials:plastic_sheet", "dye:white"},
		{"basic_materials:plastic_sheet", "basic_materials:plastic_sheet", "basic_materials:plastic_sheet"},
		{"dye:dark_green", "basic_materials:plastic_sheet", "dye:red"}
	},
})

core.register_craft({
	output = "homedecor:piano",
	recipe = {
		{ "", "basic_materials:steel_wire", "building_blocks:hardwood" },
		{ "basic_materials:plastic_strip", "basic_materials:steel_wire", "building_blocks:hardwood" },
		{ "basic_materials:brass_ingot", "default:steelblock", "building_blocks:hardwood" }
	},
})

core.register_craft({
	output = "homedecor:wall_shelf 2",
	recipe = {
		{ "homedecor:wood_table_small_square", "homedecor:curtainrod_wood", "homedecor:curtainrod_wood" },
	},
})

core.register_craft({
	output = "homedecor:trophy 3",
	recipe = {
		{ "default:gold_ingot","","default:gold_ingot" },
		{ "","default:gold_ingot","" },
		{ "group:wood","default:gold_ingot","group:wood" }
	},
})

core.register_craft({
	output = "homedecor:sportbench",
	recipe = {
		{ "stairs:slab_steelblock","basic_materials:steel_bar","stairs:slab_steelblock" },
		{ "default:steel_ingot","wool:black","default:steel_ingot" },
		{ "default:steel_ingot","wool:black","default:steel_ingot" }
	},
})

core.register_craft({
	output = "homedecor:skateboard",
	recipe = {
		{ "dye:yellow","dye:green","dye:blue" },
		{ "homedecor:wood_table_small_square","homedecor:wood_table_small_square","homedecor:wood_table_small_square" },
		{ "default:steel_ingot","","default:steel_ingot" }
	},
})

core.register_craft({
	output = "homedecor:spiral_staircase",
	recipe = {
		{ "default:steelblock", "homedecor:pole_wrought_iron", "" },
		{ "", "homedecor:pole_wrought_iron", "default:steelblock" },
		{ "default:steelblock", "homedecor:pole_wrought_iron", "" }
	},
})

core.register_craftitem(":homedecor:flower_pot_small", {
	description = S("Small Flower Pot"),
	inventory_image = "homedecor_flowerpot_small_inv.png"
})

core.register_craft( {
	output = "homedecor:flower_pot_small",
	recipe = {
		{ "default:clay_brick", "", "default:clay_brick" },
		{ "", "default:clay_brick", "" }
	}
})

core.register_craft( {
	output = "homedecor:flower_pot_small 3",
	recipe = { { "homedecor:flower_pot_terracotta" } }
})

for i in ipairs(homedecor_misc.banister_materials) do

	local name    = homedecor_misc.banister_materials[i][1]
	local topmat  = homedecor_misc.banister_materials[i][5]
	local vertmat = homedecor_misc.banister_materials[i][6]
	local dye1    = homedecor_misc.banister_materials[i][7]
	local dye2    = homedecor_misc.banister_materials[i][8]

	core.register_craft({
		output = "homedecor:banister_"..name.."_horizontal 2",
		recipe = {
			{ topmat,  "",      dye1   },
			{ vertmat, topmat,  ""     },
			{ dye2,    vertmat, topmat }
		},
	})
end

unifieddyes.register_color_craft({
	output = "",
	palette = "split",
	neutral_node = "homedecor:banister_wood_horizontal",
	type = "shapeless",
	output_prefix = "homedecor:banister_wood_horizontal_",
	output_suffix = "",
	recipe = {
		"NEUTRAL_NODE",
		"MAIN_DYE",
	}
})

-- Japanese-style wood/paper wall pieces and door

local jp_cbox = {
	type = "fixed",
	fixed = {-0.5, -0.5, 0, 0.5, 0.5, 0.0625},
}

core.register_node(":homedecor:japanese_wall_top", {
	description = S("Japanese wall (top)"),
	drawtype = "mesh",
	mesh = "homedecor_wall_japanese_top.obj",
	tiles = {
		homedecor.lux_wood,
		"homedecor_japanese_paper.png"
	},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {snappy=3, axey=5},
	is_ground_content = false,
	_mcl_hardness=1.6,
	selection_box = jp_cbox,
	collision_box = jp_cbox,
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
})

core.register_node(":homedecor:japanese_wall_middle", {
	description = S("Japanese wall"),
	drawtype = "mesh",
	mesh = "homedecor_wall_japanese_middle.obj",
	tiles = {
		homedecor.lux_wood,
		"homedecor_japanese_paper.png"
	},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {snappy=3, axey=5},
	is_ground_content = false,
	_mcl_hardness=1.6,
	selection_box = jp_cbox,
	collision_box = jp_cbox,
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
})

core.register_node(":homedecor:japanese_wall_bottom", {
	description = S("Japanese wall (bottom)"),
	drawtype = "mesh",
	mesh = "homedecor_wall_japanese_bottom.obj",
	tiles = {
		homedecor.lux_wood,
		"homedecor_japanese_paper.png"
	},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {snappy=3, axey=5},
	is_ground_content = false,
	_mcl_hardness=1.6,
	selection_box = jp_cbox,
	collision_box = jp_cbox,
	_sound_def = {
		key = "node_sound_wood_defaults",
	},
})
