local utils = ...
local S = utils.S



local function on_secondary_use (itemstack, placer, pointed_thing)
	if placer and placer:is_player () then
		if not utils.is_creative (placer) or
			not utils.check_privs (placer) then

			return itemstack
		end

		local map = utils.get_player_copy_buffer (placer)
		local schem = ""

		if map then
			local success, result = pcall (minetest.serialize, map)

			if success then
				schem = result
			end
		end

		local spec =
		"formspec_version[3]"..
		"size[11,12.5]"..
		"textarea[0.5,0.5;10,10;clipboard;;"..
		 minetest.formspec_escape (schem)..
		"]button_exit[4.5,11;2,1;set;Set]"

		minetest.show_formspec (placer:get_player_name (), "lwcreative_tools:buffer", spec)
	end

	return itemstack
end



local function on_place (itemstack, placer, pointed_thing)
	if pointed_thing and pointed_thing.under then
		local under = pointed_thing.under
		local on_rightclick = utils.get_on_rightclick (under, placer)
		if on_rightclick then
			return on_rightclick (under, utils.get_far_node (under), placer, itemstack, pointed_thing)
		end
	end

	return on_secondary_use (itemstack, placer, pointed_thing)
end



minetest.register_craftitem ("lwcreative_tools:buffer", {
	description = S("Buffer"),
	short_description = S("Buffer"),
	groups = { },
	inventory_image = "lwcreative_buffer.png",
	wield_image = "lwcreative_buffer.png",
	stack_max = 1,
	on_place = on_place,
	on_secondary_use = on_secondary_use,
})



local function get_deserialized_map (contents)
	if not (contents:sub (1, 100):find ("[^%w%c%p%s]", 1, false)) then
		local success, map = pcall (minetest.deserialize, contents, true)

		if success then
			return map
		end
	end

	return nil
end



minetest.register_on_player_receive_fields (function (player, formname, fields)
   if formname == "lwcreative_tools:buffer" and player and player:is_player () then
		if player and player:is_player () and
				fields.set and type (fields.clipboard) == "string" then
			local contents = string.trim (fields.clipboard)

			if contents:len () > 0 then
				local map = get_deserialized_map (contents)

				if map and utils.set_player_copy_buffer_by_map (player, map) then
					utils.player_message (player, "Copy buffer set.")
				else
					utils.player_error_message (player, "Schematic format error!")
				end
			else
				-- is empty so clear
				utils.clear_player_copy_buffer (player)
				utils.player_message (player, "Copy buffer cleared.")
			end
		end
	end

	return nil
end)
