local utils = ...
local S = utils.S



local function display_load_form (player_name)
	local maps = minetest.get_dir_list (utils.saved_maps_folder (player_name), false)

	table.sort (maps)

	for i = 1, #maps, 1 do
		maps[i] = minetest.formspec_escape (maps[i])
	end

	local spec =
	"formspec_version[3]"..
	"size[10.0,4.3,false]"..
	"label[1.0,1.25;Open]"..
	"dropdown[1.0,1.5;7.0,0.8;map_name;"..table.concat (maps, ",")..";1;false]"..
	"image_button[8.2,1.5;0.8,0.8;lwcreative_tools_trash_button.png;trash;]"..
	"button_exit[3.75,2.5;2.5,0.8;load;Load]"

	minetest.show_formspec (player_name, "lwcreative_tools:load", spec)
end



local function on_secondary_use (itemstack, placer, pointed_thing)
	if not utils.is_creative (placer) or
		not utils.check_privs (placer) then

		return itemstack
	end

	display_load_form (placer:get_player_name ())

	return itemstack
end



local function on_place (itemstack, placer, pointed_thing)
	if not utils.is_creative (placer) or
		not utils.check_privs (placer) then

		return itemstack
	end

	local on_rightclick = utils.get_on_rightclick (pointed_thing.under, placer)
	if on_rightclick then
		return on_rightclick (pointed_thing.under, utils.get_far_node (pointed_thing.under), placer, itemstack, pointed_thing)
	end

	return on_secondary_use (itemstack, placer, pointed_thing)
end



local function on_use (itemstack, user, pointed_thing)
	return nil
end



minetest.register_craftitem ("lwcreative_tools:load", {
	description = S("Load"),
	short_description = S("Load"),
	groups = { },
	inventory_image = "lwcreative_tools_load.png",
	wield_image = "lwcreative_tools_load.png",
	stack_max = 1,
	on_place = on_place,
	on_secondary_use = on_secondary_use,
	on_use = on_use,
})



local function confirm_trash (player_name, map_name)
	local spec =
	"formspec_version[3]"..
	"size[7.5,4.3,false]"..
	"label[1.0,1.4;Permanently delete "..minetest.formspec_escape (map_name).."?]"..
	"button_exit[1.0,2.5;2.5,0.8;confirm;Confirm]"..
	"button_exit[4.0,2.5;2.5,0.8;cancel;Cancel]"..
	"field[1.0,6.0;0,0;map_name;;"..minetest.formspec_escape (map_name).."]"

	minetest.show_formspec (player_name, "lwcreative_tools:trash_confirm", spec)
end



minetest.register_on_player_receive_fields (function (player, formname, fields)
   if formname == "lwcreative_tools:load" and player and player:is_player () then

		if fields.trash and type (fields.map_name) == "string" and fields.map_name:len () > 0 then
			if utils.save_map_exists (player, fields.map_name) then
				minetest.after (0.1, confirm_trash, player:get_player_name (), fields.map_name)

				return
			end
		end

		if fields.load and type (fields.map_name) == "string" and fields.map_name:len () > 0 then
			if utils.load_player_map (player, fields.map_name) then
				utils.player_message (player, string.format ("Copy buffer loaded from %s", fields.map_name))
			else
				utils.player_error_message (player, string.format ("An error occurred loading %s!", fields.map_name))
			end

			return
		end
	end
end)



minetest.register_on_player_receive_fields (function (player, formname, fields)
   if formname == "lwcreative_tools:trash_confirm" and player and player:is_player () then
		if fields.confirm and fields.map_name then
			utils.delete_map (player, fields.map_name)
		end

		minetest.after (0.1, display_load_form, player:get_player_name ())
	end
end)
