local utils = ...
local S = utils.S



local player_data = { }



local function display_load_form (player_name)
	player_data[player_name] = { }

	local maps = minetest.get_dir_list (utils.saved_maps_folder (player_name), false)

	table.sort (maps)

	for i = 1, #maps, 1 do
		maps[i] = minetest.formspec_escape (maps[i])
	end

	local spec =
	"formspec_version[3]"..
	"size[10.0,4.3,false]"..
	"label[1.0,1.25;Open]"..
	"dropdown[1.0,1.5;7.0,0.8;map_name;"..table.concat (maps, ",")..";1;false]"..
	"image_button[8.2,1.5;0.8,0.8;lwcreative_tools_trash_button.png;trash;]"..
	"button_exit[3.75,2.5;2.5,0.8;load;Load]"

	minetest.show_formspec (player_name, "lwcreative_tools:load", spec)
end



local function display_confirm_trash (player_name, map_name)
	local data = player_data[player_name]

	if data and data.map_name then
		local spec =
		"formspec_version[3]"..
		"size[7.5,4.3,false]"..
		"label[1.0,1.4;Permanently delete "..minetest.formspec_escape (data.map_name).."?]"..
		"button_exit[1.0,2.5;2.5,0.8;confirm_trash;Confirm]"..
		"button_exit[4.0,2.5;2.5,0.8;cancel;Cancel]"

		minetest.show_formspec (player_name, "lwcreative_tools:load", spec)
	end
end



local function on_secondary_use (itemstack, placer, pointed_thing)
	if not utils.is_creative (placer) or
		not utils.check_privs (placer) then

		return itemstack
	end

	if not player_data[placer:get_player_name ()] then
		display_load_form (placer:get_player_name ())
	end

	return itemstack
end



local function on_place (itemstack, placer, pointed_thing)
	if not utils.is_creative (placer) or
		not utils.check_privs (placer) then

		return itemstack
	end

	local on_rightclick = utils.get_on_rightclick (pointed_thing.under, placer)
	if on_rightclick then
		return on_rightclick (pointed_thing.under, utils.get_far_node (pointed_thing.under), placer, itemstack, pointed_thing)
	end

	return on_secondary_use (itemstack, placer, pointed_thing)
end



local function on_use (itemstack, user, pointed_thing)
	return nil
end



minetest.register_craftitem ("lwcreative_tools:load", {
	description = S("Load"),
	short_description = S("Load"),
	groups = { },
	inventory_image = "lwcreative_tools_load.png",
	wield_image = "lwcreative_tools_load.png",
	stack_max = 1,
	on_place = on_place,
	on_secondary_use = on_secondary_use,
	on_use = on_use,
})



local function load_map_runner (player_name, map_name)
	local player = minetest.get_player_by_name (player_name)

	if player then
		if utils.load_player_map (player, map_name) then
			utils.player_message (player_name, string.format ("Copy buffer loaded from %s", map_name))
		else
			utils.player_error_message (player_name, string.format ("An error occurred loading %s!", map_name))
		end
	end
end



minetest.register_on_player_receive_fields (function (player, formname, fields)
   if formname == "lwcreative_tools:load" and player and player:is_player () then
		if fields.trash then
			if type (fields.map_name) == "string" and fields.map_name:len () > 0 then
				if utils.save_map_exists (player, fields.map_name) then
					player_data[player:get_player_name ()] = { map_name = fields.map_name }

					minetest.after (0.1, display_confirm_trash, player:get_player_name (), fields.map_name)

					return
				end
			end

			player_data[player:get_player_name ()] = { }

			return

		elseif fields.load then
			if type (fields.map_name) == "string" and fields.map_name:len () > 0 then
				if not utils.add_long_process (player:get_player_name (), load_map_runner, nil,
														 player:get_player_name (), fields.map_name) then
					utils.player_error_message (player:get_player_name (), "An operation is already in progress!")
				end
			end

		elseif fields.confirm_trash then
			local data = player_data[player:get_player_name ()]

			if data and data.map_name then
				if utils.delete_map (player, data.map_name) then
					utils.player_message (player:get_player_name (), string.format ("Deleted %s", data.map_name))
				else
					utils.player_error_message (player:get_player_name (),
														 string.format ("Error deleting %s!", data.map_name))
				end
			end

			minetest.after (0.1, display_load_form, player:get_player_name ())

			return

		elseif fields.cancel then
			minetest.after (0.1, display_load_form, player:get_player_name ())

			return

		end

		if fields.quit then
			player_data[player:get_player_name ()] = nil
		end
	end
end)
