local utils = ...
local S = utils.S



if not utils.settings.disable_buffer_tool then



local player_data = { }



local function show_form (player_name)
	local data = player_data[player_name]

	if data then
		minetest.show_formspec (player_name, "lwcreative_tools:buffer", data.spec)

		player_data[player_name] = nil
	end
end



local function display_warning (player_name)
	local data = player_data[player_name]

	if data then
		local warning

		if data.spec:len () > 1000000 then
			warning = "Displaying the form will take a VERY long time!"
		elseif data.spec:len () > 500000 then
			warning = "Displaying the form could take a long time!"
		elseif data.spec:len () > 150000 then
			warning = "Displaying the form could take a while."
		else
			show_form (player_name)

			return
		end

		local spec =
		"formspec_version[3]"..
		"size[10.5,4.3,false]"..
		"label[1.0,1.4;"..warning.."]"..
		"button_exit[1.0,2.5;2.5,0.8;continue;Continue]"..
		"button_exit[7.0,2.5;2.5,0.8;cancel;Cancel]"

		minetest.show_formspec (player_name, "lwcreative_tools:buffer", spec)
	end
end



local function on_secondary_use (itemstack, placer, pointed_thing)
	if placer and placer:is_player () then
		if not utils.is_creative (placer) or
			not utils.check_privs (placer) then

			return itemstack
		end

		local map = utils.get_player_copy_buffer (placer)
		local schem = ""

		if map then
			local success, result = pcall (minetest.serialize, map)

			if success then
				schem = result
			end
		end

		local spec =
		"formspec_version[3]"..
		"size[11,12.5]"..
		"textarea[0.5,0.5;10,10;clipboard;;"..
		 minetest.formspec_escape (schem)..
		"]button_exit[4.5,11;2,1;set;Set]"

		if not player_data[placer:get_player_name ()] then
			player_data[placer:get_player_name ()] =
			{
				spec = spec
			}

			display_warning (placer:get_player_name ())
		end
	end

	return itemstack
end



local function on_place (itemstack, placer, pointed_thing)
	if pointed_thing and pointed_thing.under then
		local under = pointed_thing.under
		local on_rightclick = utils.get_on_rightclick (under, placer)
		if on_rightclick then
			return on_rightclick (under, utils.get_far_node (under), placer, itemstack, pointed_thing)
		end
	end

	return on_secondary_use (itemstack, placer, pointed_thing)
end



minetest.register_craftitem ("lwcreative_tools:buffer", {
	description = S("Buffer"),
	short_description = S("Buffer"),
	groups = { },
	inventory_image = "lwcreative_buffer.png",
	wield_image = "lwcreative_buffer.png",
	stack_max = 1,
	on_place = on_place,
	on_secondary_use = on_secondary_use,
})



local function get_deserialized_map (contents)
	local success, map = pcall (utils.deserialize, contents)

	if success then
		return map
	end

	return nil
end



local function set_buffer_runner (contents, player_name)
	local player = minetest.get_player_by_name (player_name)

	if player then
		local map = get_deserialized_map (contents)

		if map and utils.set_player_copy_buffer_by_map (player, map) then
			utils.player_message (player, "Copy buffer set.")
		else
			utils.player_error_message (player, "Schematic format error!")
		end
	end
end



minetest.register_on_player_receive_fields (function (player, formname, fields)
   if formname == "lwcreative_tools:buffer" and player and player:is_player () then
		if fields.set then
			if type (fields.clipboard) == "string" then
				local contents = string.trim (fields.clipboard)

				if contents:len () > 0 then
					if not utils.add_long_process (player:get_player_name (), set_buffer_runner,
															 nil, contents, player:get_player_name ()) then
						utils.player_error_message (player, "An operation is already in progress!")
					end
				else
					-- is empty so clear
					utils.clear_player_copy_buffer (player)
					utils.player_message (player, "Copy buffer cleared.")
				end
			end

		elseif fields.continue then
			show_form (player:get_player_name ())

			return
		end

		if fields.quit then
			player_data[player:get_player_name ()] = nil
		end
	end

	return nil
end)



end
