local utils = ...
local S = utils.S



local player_data = { }



local function display_save_form (player_name)
	local data = player_data[player_name]
	local map_name = ""

	if data and data.map_name then
		map_name = data.map_name
	end

	player_data[player_name] = { }

	local spec =
	"formspec_version[3]"..
	"size[9.0,4.3,false]"..
	"field[1.0,1.5;7.0,0.8;map_name;Save as;"..tostring (map_name).."]"..
	"button_exit[3.25,2.5;2.5,0.8;save;Save]"

	minetest.show_formspec (player_name, "lwcreative_tools:save", spec)
end



local function display_confirm_overwrite (player_name)
	local data = player_data[player_name]

	if data and data.map_name then
		local spec =
		"formspec_version[3]"..
		"size[7.5,4.3,false]"..
		"label[1.0,1.4;"..minetest.formspec_escape (data.map_name).." exists]"..
		"button_exit[1.0,2.5;2.5,0.8;confirm_overwrite;Overwrite]"..
		"button_exit[4.0,2.5;2.5,0.8;cancel;Cancel]"

		minetest.show_formspec (player_name, "lwcreative_tools:save", spec)
	end
end



local function on_secondary_use (itemstack, placer, pointed_thing)
	if not utils.is_creative (placer) or
		not utils.check_privs (placer) then

		return itemstack
	end

	if utils.get_player_copy_buffer (placer) then
		display_save_form (placer:get_player_name ())

	elseif placer and placer:is_player () then
		utils.player_error_message (placer, "No copy buffer!")

	end

	return itemstack
end



local function on_place (itemstack, placer, pointed_thing)
	if not utils.is_creative (placer) or
		not utils.check_privs (placer) then

		return itemstack
	end

	local on_rightclick = utils.get_on_rightclick (pointed_thing.under, placer)
	if on_rightclick then
		return on_rightclick (pointed_thing.under, utils.get_far_node (pointed_thing.under), placer, itemstack, pointed_thing)
	end

	return on_secondary_use (itemstack, placer, pointed_thing)
end



local function on_use (itemstack, user, pointed_thing)
	return nil
end



minetest.register_craftitem ("lwcreative_tools:save", {
	description = S("Save"),
	short_description = S("Save"),
	groups = { },
	inventory_image = "lwcreative_tools_save.png",
	wield_image = "lwcreative_tools_save.png",
	stack_max = 1,
	on_place = on_place,
	on_secondary_use = on_secondary_use,
	on_use = on_use,
})



local function save_map (player, map_name)
	if utils.save_player_map (player, map_name) then
		utils.player_message (player, string.format ("Copy buffer saved as %s", map_name))

		minetest.log ("action", string.format ("lwcreative_tools %s saved by %s",
															map_name,
															player:get_player_name ()))
	else
		utils.player_error_message (player, string.format ("An error occurred saving %s!", map_name))
	end
end



minetest.register_on_player_receive_fields (function (player, formname, fields)
   if formname == "lwcreative_tools:save" and player and player:is_player () then
		if (fields.save or (fields.key_enter_field and fields.key_enter_field == "map_name")) then
			if type (fields.map_name) == "string" and fields.map_name:len () > 0 then
				if utils.save_map_exists (player, fields.map_name) then
					player_data[player:get_player_name ()] = { map_name = fields.map_name }

					minetest.after (0.1, display_confirm_overwrite, player:get_player_name ())

					return
				else
					save_map (player, fields.map_name)
				end
			end

		elseif fields.confirm_overwrite then
			local data = player_data[player:get_player_name ()]

			if data and data.map_name then
				save_map (player, data.map_name)
			end

		elseif fields.cancel then
			minetest.after (0.1, display_save_form, player:get_player_name ())

			return

		end

		if fields.quit then
			player_data[player:get_player_name ()] = nil
		end
	end
end)
