local http = ...

mtt.register("Promise.http GET", function(callback)
    Promise.http(http, "https://api.chucknorris.io/jokes/random"):next(function(res)
        return res.json()
    end):next(function(joke)
        assert(type(joke.value) == "string")
        callback()
    end):catch(function(e)
        callback(e)
    end)
end)

mtt.register("Promise.http/all GET", function(callback)
    local toJson = function(res) return res.json() end
    local p1 = Promise.http(http, "https://api.chucknorris.io/jokes/random"):next(toJson)
    local p2 = Promise.http(http, "https://api.chucknorris.io/jokes/random"):next(toJson)

    Promise.all(p1, p2):next(function(values)
        assert(#values == 2)
        assert(type(values[1].value) == "string")
        assert(type(values[2].value) == "string")
        callback()
    end):catch(function(e)
        callback(e)
    end)
end)

mtt.register("Promise.http GET not found", function(callback)
    Promise.http(http, "https://httpbin.org/status/404"):next(function(res)
        assert(res)
        assert(res.code == 404)
        callback()
    end):catch(function(e)
        callback(e)
    end)
end)

mtt.register("Promise.http GET internal erorr", function(callback)
    Promise.http(http, "https://httpbin.org/status/500"):next(function(res)
        assert(res)
        assert(res.code == 500)
        callback()
    end):catch(function(e)
        callback(e)
    end)
end)

mtt.register("Promise.http POST", function(callback)
    local opts = { method = "POST", data = { x=1 }}
    Promise.http(http, "https://postman-echo.com/post", opts):next(function(res)
        return res.json()
    end):next(function(data)
        assert(type(data) == "table")
        assert(data.json and data.json.x == 1)
        callback()
    end):catch(function(e)
        callback(e)
    end)
end)