

mtt.register("Promise.all (success)", function(callback)
    local p1 = Promise.new(function(resolve)
        resolve(5)
    end)

    local p2 = Promise.new(function(resolve)
        resolve(10)
    end)

    Promise.all(p1, p2):next(function(values)
        assert(#values == 2)
        assert(values[1] == 5)
        assert(values[2] == 10)
        callback()
    end):catch(function(err)
        callback(err)
    end)
end)

mtt.register("Promise.all (error)", function(callback)
    local p1 = Promise.new(function(resolve)
        resolve(5)
    end)

    local p2 = Promise.new(function(_, reject)
        reject("stuff")
    end)

    Promise.all(p1, p2):next(function()
        callback("unexpected success")
    end):catch(function(err)
        assert(err[1] == nil)
        assert(err[2] == "stuff")
        callback()
    end)
end)

mtt.register("Promise.race (success)", function(callback)
    local p1 = Promise.resolve(5)
    local p2 = Promise.new()

    Promise.race(p1, p2):next(function(v)
        assert(v == 5)
        callback()
    end)
end)

mtt.register("Promise.race (error)", function(callback)
    local p1 = Promise.reject("whatever")
    local p2 = Promise.new()

    Promise.race(p1, p2):next(function()
        callback("unexpected success")
    end):catch(function(err)
        assert(err == "whatever")
        callback()
    end)
end)

mtt.register("Promise.race (timeout error)", function(callback)
    local p = Promise.new()
    local to = Promise.after(0.1, nil, "whatever")

    Promise.race(p, to):next(function()
        callback("unexpected success")
    end):catch(function(err)
        assert(err == "whatever")
        callback()
    end)
end)

mtt.register("Promise.any (success)", function(callback)
    local p1 = Promise.resolve(5)
    local p2 = Promise.reject("stuff")

    Promise.any(p1, p2):next(function(v)
        assert(v == 5)
        callback()
    end)
end)

mtt.register("Promise.any (error)", function(callback)
    local p1 = Promise.reject("stuff1")
    local p2 = Promise.reject("stuff2")

    Promise.any(p1, p2):next(function()
        callback("unexpected success")
    end):catch(function(errors)
        assert(errors[1] == "stuff1")
        assert(errors[2] == "stuff2")
        callback()
    end)
end)
