
mtt.register("Promise.async", function(callback)
    local p = Promise.async(function(await)
        local v = await(Promise.after(0, 42))
        assert(v == 42)
        local v1 = await(Promise.resolve(666))
        assert(v1 == 666)
        return 99
    end)

    p:next(function(v)
        assert(v == 99)
        callback()
    end)
end)

mtt.register("Promise.async interop", function()
    return Promise.async(function(await)
        return await(Promise.async(function(await2)
            local v = await2(Promise.resolve(42))
            assert(v == 42)
        end))
    end)
end)

mtt.register("Promise.async simple", function()
    return Promise.async(function(await)
        local v = await(Promise.resolve(42))
        assert(v == 42)
    end)
end)

mtt.register("Promise.async with handle_async", function()
    return Promise.async(function(await)
        local v, err = await(Promise.resolve(42))
        assert(v == 42)
        assert(not err)
        v, err = await(Promise.handle_async(function() return 100 end))
        assert(v == 100)
        assert(not err)
    end)
end)

mtt.register("Promise.async error propagation", function()
    return Promise.async(function(await)
        local v, err = await(Promise.reject("my-err"))
        assert(not v)
        assert(err == "my-err")
    end)

end)

mtt.register("Promise.async direct error", function(callback)
    local p = Promise.async(function()
        error("stuff", 0)
    end)

    p:catch(function(e)
        assert(type(e) == "string")
        assert(e == "stuff")
        callback()
    end)
end)