-- Function to handle digging of grass nodes
local function on_dig_grass(pos, node, digger)
	-- Replace the grass node with dirt
	local dirtdef = minetest.get_content_id("mapgen_dirt")
	local dirtname = minetest.get_name_from_content_id(grassdef)
	--minetest.set_node(pos, {name = grassname})

	-- Get the drops for the grass node
	local drops = minetest.get_node_drops(node.name, digger:get_wielded_item())

	-- Add drops to the player's inventory
	local inv = digger:get_inventory()
	for _, drop in ipairs(drops) do
		inv:add_item("main", drop)
	end
end

-- Register the custom on_dig callback for grass nodes
minetest.register_on_mods_loaded(function()
	local grassdef = minetest.get_content_id("mapgen_dirt_with_grass")
	local grassnodes = {grassdef}
	for _, nodename in ipairs(grassnodes) do
		local olddef = minetest.registered_nodes[nodename]
		if olddef then
			minetest.override_item(nodename, {
				on_dig = function(pos, node, digger)
					--on_dig_grass(pos, node, digger)
					if olddef.on_dig then
						olddef.on_dig(pos, node, digger)
					end
				end,
			})
		end
	end
end)

