local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local print = c.log

-- Function to set hotbar image and item count
local function set_hotbar_properties(player, itemcount)
	if player and player:is_player() then
		player:hud_set_hotbar_image("minimap_overlay_square.png")
		player:hud_set_hotbar_itemcount(itemcount)
		player:hud_set_hotbar_selected_image("minimap_overlay_square.png")
		local inv = player:get_inventory()
		inv:set_size("main", itemcount)
	end
end
local function logform(player, formname, fields)
	for key, value in pairs(fields) do
		--c.log("form:"..formname..";"..key..":"..value..", returned!")
		c.log("form:"..formname..";"..key..", returned!")
	end
end
local function getform(player, formname, fields)
	for key, value in pairs(fields) do
		if key and key ~= "quit" then
			return key
		end
	end
end
local switch = function(param, case_table)
    local case = case_table[param]
    if case then return case() end
    local def = case_table['default']
    return def and def() or nil
end

local function set_item (player, itemstring, invname, invindex)
    if player and player:is_player() then
        local inv = player:get_inventory()
        local stack = ItemStack(itemstring)
        inv:set_stack(invname, invindex, stack)
	end
end
local wands = {modname..":".."lost_child", modname..":".."ballpoint", modname..":".."bloodletter" }
local function on_player_receive_fields(player, formname, fields)
	
	if formname == "select_wand" then
		--logform(player, formname, fields)
		c.log(getform(player, formname, fields))
		local print = function (...) end
	
		switch(getform(player, formname, fields), { 
			__index = function()	-- for case default
				set_item(player, wands[0+1].." 1", "main", 1)
				player:set_pos({x = 0.0, y = 1.5, z = 0.0})
				print("-1")
			end,
			["select_wand_one"] = function()	
				set_item(player, wands[0+1].." 1", "main", 1)
				player:set_pos({x = 0.0, y = 1.5, z = 0.0})
				print("-1")
				end,
			["select_wand_two"] = function()	
				set_item(player, wands[1+1].." 1", "main", 1)
				player:set_pos({x = 0.0, y = 1.5, z = 0.0})
				print("-2")
			end,
			["select_wand_iii"] = function()	
				set_item(player, wands[2+1].." 1", "main", 1)
				player:set_pos({x = 0.0, y = 1.5, z = 0.0})
				print("-3")
			end,
		})
		return false
	end

	return true
end

local function show_formspec_wands(player)
	local index0 = minetest.registered_items["wismod:lost_child"].inventory_image or ""
	local index1 = minetest.registered_items[wands[1+1]].inventory_image or ""
	local index2 = minetest.registered_items[wands[2+1]].inventory_image or ""
	--c.log(type(index0))
	--c.log(index0)
	local formspec = [[
	formspec_version[6]
	size[24,12]
	position[0.5,0.5]
	anchor[0.5,0.5]
	bgcolor[;false]
	image_button[6,1;12,2;blank.png;select_wand_label;select wand;false;false]
	image_button_exit[1,4;6,6;]]..index0..[[;select_wand_one;]
	image_button_exit[9,4;6,6;]]..index1..[[;select_wand_two;]
	image_button_exit[17,4;6,6;]]..index2..[[;select_wand_iii;]
	]]
	
	minetest.show_formspec(player:get_player_name(), "select_wand", formspec)
	
end
local function  respawn(player) 
	local pos = {x = 0.0, y = 0, z = 0.0} --player:get_pos()

	-- Print the player's position
	--c.log("Player spawned at position: x=" .. pos.x .. ", y=" .. pos.y .. ", z=" .. pos.z)
	
	--set spawn
	player:set_pos({x = 0.0, y = -8.5, z = 0.0})
	show_formspec_wands(player)

end

local function join(player,last_login)
	
	c.log("joined")
	set_hotbar_properties(player, 1)
	respawn(player)
end
local function leave(player, timed_out)
	c.log("left")
end
local function step(dtime)
	--c.log("step:"..dtime)
	
end


minetest.register_on_joinplayer(join);
minetest.register_on_newplayer(join);
minetest.register_on_respawnplayer( respawn );
minetest.register_on_leaveplayer(leave);
minetest.register_globalstep(step);
minetest.register_on_player_receive_fields( on_player_receive_fields );
--minetest.register_on_punchplayer( on_punchplayer );
--minetest.register_on_rightclickplayer( on_rightclickplayer );
--minetest.register_on_player_hpchange( on_hpchange );


--
