#?replace(sub = "\t", by =" ")

import std/os as os
import std/parsecfg
import std/strutils
#import tables

# Function to check if a file ends with any of the given extensions
proc endsWithAny(file: string, extensions: seq[string]): bool =
	for ext in extensions:
		if file.endsWith(ext):
			return true
	return false

# Function to list all files and then process them
proc listFilesForAction(baseDir: string, processFile: proc (file: string)) =
	proc traverseDirectory(dir: string, files: var seq[string], processFile: proc (file: string)) =
		for kind, path in walkDir(dir):
			case kind
			of pcFile, pcLinkToFile:
				files.add(path)
				#echo "Processing file: ", path
				processFile(path)
			of pcDir, pcLinkToDir:
				#echo "Processing folder: ", path
				traverseDirectory(path, files, processFile)
	var allFiles: seq[string]
	traverseDirectory(baseDir, allFiles, processFile)


# Function to read key-value pairs from a file and return as an ordered sequence
proc readKeyValuePairs(filePath: string): seq[(string, string)] =
	var keyValuePairs: seq[(string, string)] = @[]
	
	# Check if the file exists
	if not fileExists(filePath):
		echo "File does not exist: ", filePath
		return keyValuePairs

	# Open the file and read line by line
	for line in lines(filePath):
		# Skip empty lines
		if line.strip() == "":
			continue
		
		var parts: seq[string] = @[]
		# Keep comments lines
		if line.strip().startsWith("#") or line.strip().startsWith(";"):
			parts = @[line, ""]
		else:
			# Split the line by '='
			parts = line.split('=')
			if parts.len > 1:
				parts[1] = parts[1] & ""
			else:
				parts = @[parts[0], ""]
		# Ensure there are exactly two parts (key and value)
		if parts.len == 2:
			let key = parts[0].strip()
			let value = parts[1]
			keyValuePairs.add((key, value))
			echo "'",key,"'",":","'",value,"'"
		else:
			echo "Invalid line: ", line
		
	return keyValuePairs

# Function to write key-value pairs to a file
proc writeKeyValuePairs(filePath: string, keyValuePairs: seq[(string, string)]) =
	# Open the file for writing
	let file = open(filePath, fmWrite)
	defer: file.close()
	
	# Write each key-value pair to the file
	for kv in keyValuePairs:
		let key = kv[0]
		let value = kv[1]
		if value == "":
			file.writeLine(key)
		else:
			file.writeLine(key & " = " & value.strip())


# Function to print key-value pairs for debugging

# Function to process files
proc processFiles*(path: string) =
	discard
	let extensions = @["game.conf", "mod.conf", "modpack.conf"]
	if not endsWithAny(path, extensions):
		return
	echo "Processing file: ", path
	#printKeyValuePairs(path)
	var keyValuePairs = readKeyValuePairs(path)
	for i in 0..<keyValuePairs.len:
		let key = keyValuePairs[i][0]
		let value = keyValuePairs[i][1]
		#echo key, " = ", value
		if key == "name":
			keyValuePairs[i][1] = splitFile(splitPath(path).head).name
	writeKeyValuePairs(path, keyValuePairs)

# Example usage
proc fix*() =
	discard
	let baseDirectory = getAppFilename().splitPath().head.splitPath().head & DirSep
	echo "Processing namespaces in: ", baseDirectory
	listFilesForAction(baseDirectory, processFiles)
