#!/bin/bash

# Define the stuff
convert_line_endings() {
	for file in "$1"/*; do
		if [ -d "$file" ]; then
			convert_line_endings "$file"
		elif [ -f "$file" ]; then
			case "$file" in
				*.txt|*.ini|*.lua|*.bash|*.cmd|*.bat)
					# Convert LF to CRLF
					sed -i 's/\r\n/\n/g; s/\n/\r\n/g' "$file"
					sed -i 's/    /\t/g' "$file"
					echo "Converted: $file"
					if command -v dos2unix &> /dev/null ; then
						dos2unix -idu "$file"
					fi
					;;
			esac
		fi
	done
}

# Check if directory is provided
if [ -z "$1" ]; then
	echo "Usage: $0 <directory>"
	exit 1
fi

# Do the thing!
convert_line_endings "$1"

