
local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
-- hard coding this is a failure of the game design
local schemapath = modpath .. "/schema/smoltree.mts"
--//mtschemcreate smoltree


--registrate tree spawn params
minetest.register_on_mods_loaded(function()
	local postpendstr = "_subterranean"
	for name, _ in pairs(minetest.registered_biomes) do
		if name:sub(-#postpendstr) ~= postpendstr then
			--c.log("Biome name: " .. name)
			minetest.register_decoration({
			deco_type = "schematic",
				place_on = {"group:dirt"},
				sidelen = 80,
				noise_params = {
					offset = 0,
					scale = 0.05,
					spread = {x = 1024, y = 10, z = 1024},
					seed = minetest.get_mapgen_setting("seed"),
					octaves = 4,
					persistence = 0.5,
					lacunarity = 1.0,
				},
				y_max = minetest.registered_biomes.y_max,
				y_min = minetest.registered_biomes.y_min,
				schematic = schemapath,
				flags = "place_center_x, place_center_z",
				rotation = "random",
				biomes = {name},
			})
		end
	end
-- leaf decay is a failure of the game design
-- compat: https://forum.minetest.net/viewtopic.php?t=18023

	local leafdecaynodes = {}
	for name, def in pairs(minetest.registered_nodes) do
		if def.groups and def.groups.leafdecay then
			table.insert(leafdecaynodes, name)
		end
	end

	local treenodes = {}
	for name, def in pairs(minetest.registered_nodes) do
		if def.groups and def.groups.tree then
			table.insert(treenodes, name)
		end
	end
	--c.log(#treenodes)
	local leafdecayradius = 1
	minetest.register_abm({
		nodenames = leafdecaynodes,
		neighbors = {"air"},
		interval = 1, -- Time in seconds between ABM execution
		chance = 1,  -- 1 in $% chance for the ABM to run
		action = function(pos, node, active_object_count, active_object_count_wider)
			local foundtree = false
			for dx = -leafdecayradius, leafdecayradius do
				for dy = -leafdecayradius, leafdecayradius do
					for dz = -leafdecayradius, leafdecayradius do
						local p = {x = pos.x + dx, y = pos.y + dy, z = pos.z + dz}
						local n = minetest.get_node(p)
						if minetest.registered_nodes[n.name].groups and minetest.registered_nodes[n.name].groups.tree then
							foundtree = true
							break
						end
					end
					if foundtree then
						break
					end
				end
				if foundtree then
					break
				end
			end

			if not foundtree then
				local spawnableitem = minetest.get_node(pos)
				minetest.remove_node(pos)
				minetest.spawn_item(pos, spawnableitem) 
			end
		end,
	})

end)
