local DIR_DELIM = debug.getinfo(1, "S").source:match("[\\/]")
local modname = core.get_current_modname() 
local context = debug and debug.getinfo(1, "S").source:match("mods[/\\][/\\]?([^/]*)") or "context"
local modpath = core.get_modpath(modname)
local cwdpath = minetest and (core.get_modpath(core.get_current_modname()) .. DIR_DELIM .. "src") or debug.getinfo(1, "S").source:match("^(.+)[/\\]"):sub(2)
--local print = _G[context].log


local registrateItemFromBlob = function(blob)
	assert(blob["name"]~=nil)
	if not blob["name"]:find(":") then
		blob["name"] = table.concat({core.get_current_modname(),blob["name"]},":")
	end
	blob["type"]="none"
	local localname = blob["name"]
	blob["name"] = nil
	if blob["tool_dig_groups"] then 
		blob["tool_capabilities"] = blob["tool_capabilities"] or {}
		blob["tool_capabilities"]["groupcaps"] = blob["tool_capabilities"]["groupcaps"] or {}
		for _, value in ipairs(blob["tool_dig_groups"] ) do		
				blob["tool_capabilities"]["groupcaps"][value]={
				times = blob["tool_dig_times"] or nil,
				uses = blob["tool_dig_uses"] or nil,
				maxlevel = blob["tool_dig_maxlevel"] or nil
				}
		end
		blob["tool_capabilities"]["damage_groups"] = blob["tool_capabilities"]["damage_groups"] or nil
	end
	--print(">>",blob["tool_damage_groups"])
	minetest.register_item(localname, blob)
	--print(">>", minetest.write_json({[1] = 0.00, [2] = 2.00, [3] = 3.0, [100] = 99.0}))
end
local registrateBiomeFromBlob = function(blob)
	assert(blob["name"]~=nil)
	if not blob["name"]:find(":") then
		blob["name"] = table.concat({core.get_current_modname(),blob["name"]},":")
	end
	if blob["depth_top"]==nil and   blob["node_top_depth"]~=nil then 
		blob["depth_top"] = blob["node_top_depth"]
		--blob["node_top_depth"]=nil
	end
	if blob["depth_filler"]==nil and   blob["node_filler_depth"]~=nil then 
		blob["depth_filler"] = blob["node_filler_depth"]
		blob["node_filler_depth"]=nil
	end
	if blob["depth_riverbed"]==nil and   blob["node_riverbed_depth"]~=nil then 
		blob["depth_riverbed"] = blob["node_riverbed_depth"]
		blob["node_riverbed_depth"]=nil
	end
	local yMin = -31000
	local yMax = 31000
	local oMin = blob["y_min"] or yMin
	local oMax = blob["y_max"] or yMax
	local seaLevel = minetest.settings:get("water_level") or 1
	blob["y_min"] = blob["dune_line"] or seaLevel
	blob["y_max"] = oMax

	if blob["node_riverbed"] ~= nil or blob["node_substratum"] ~= nil then 
		blob["node_riverbed"] = blob["node_riverbed"] or blob["node_substratum"] or nil
		blob["node_substratum"] = blob["node_substratum"] or blob["node_riverbed"] or nil
	end
	if blob["node_riverbed"] == nil then
		minetest.register_biome(blob)
	else
		minetest.register_biome(blob)
		blob["name"] = table.concat({blob["name"],"_subterranean"},"")
		--e3.s
		blob["node_top"] = blob["node_riverbed"]
		blob["depth_top"] = blob["depth_riverbed"] or 1
		blob["node_filler"] = blob["node_substratum"]
		blob["depth_filler"] = blob["node_substratum_depth"] or 1

		blob["y_max"] =  blob["y_min"] - 1 
		blob["y_min"] = oMin
		--print(blob)
		
		minetest.register_biome(blob)


		
	end
	--node_riverbed = "mapgen_sand"
	--node_riverbed_depth = 3

--node_substratum="mapgen_sandstone"
--node_substratum_depth=1

end
local registrateToolFromBlob = function(blob)
	assert(blob["name"]~=nil)
	if not blob["name"]:find(":") then
		blob["name"] = table.concat({core.get_current_modname(),blob["name"]},":")
	end
	blob["type"]="none"
	local localname = blob["name"]

	blob["type"]=nil
	minetest.register_tool(localname, blob)
end

local registrateNodeFromBlob = function(blob)
	local nodeName=blob["name"]
	blob["name"]=nil
	assert(nodeName~=nil)
	if not nodeName:find(":") then
		nodeName = table.concat({core.get_current_modname(), nodeName},":")
		--print(nodeName)
	end
	local nodeAlias=blob["alias"]
	blob["alias"]=nil
	core.register_node(nodeName, blob)
	if type(nodeAlias) == "string" then 
		core.register_alias(nodeAlias,nodeName)
	elseif type(nodeAlias) == "table" then
		for key, value in ipairs(nodeAlias) do		
			core.register_alias(value, nodeName)
		end
	else
	end
	
	local wah = minetest.registered_nodes[nodeName].groups
end
_G[context].registrate_from_file = function(filePath)
	--print(filePath:match("^.+%.(.+)$"))
	for header, data in pairs(_G[context].forFileAsIniObj(filePath, false)) do		
		--print("["..header.."]")
		for k, v in pairs(data) do
			data[k]=_G[context].parse(v)
			--print("reg", data, k)
			--assert (data[k]~=nil)
		end
			
		if data["type"]  == nil then
			error("expectation not met, missing type in file:".. filePath)
		end
		assert(type(data["type"])=="string")
		local types={"node", "item", "tool", "biome", "craft"}
		if not table.contains(types, data["type"]) then 
			error("expectation not met, invalid type in file:".. filePath)
		end
		if data["type"] == "node" then
			data["type"]=nil
			registrateNodeFromBlob(data)
		end
		if data["type"] == "item" then
			data["type"]=nil
			registrateItemFromBlob(data)
		end
		if data["type"] == "tool" then
			data["type"]=nil
			registrateToolFromBlob(data)
		end
		if data["type"] == "biome" then
			data["type"]=nil
			registrateBiomeFromBlob(data)
		end
	end

end

--_G[context].registrate_from_file("")
--_G[context].registrate_from_folder("")


