-- Function to store data about a player
local function store_player_data(player, key, value)
    local meta = player:get_meta()
    meta:set_string(key, value)
end
-- Function to retrieve data about a player
local function get_player_data(player, key, default)
    local meta = player:get_meta()
    return meta:get_string(key)
end


-- Example usage: Store the player's favorite color on join
minetest.register_on_joinplayer(function(player)
    -- Store the player's favorite color
    store_player_data(player, "favorite_color", "blue")
    local favorite_color = get_player_data(player, "favorite_color")
    if false then return true; end
    if favorite_color ~= "" then
        minetest.chat_send_player(player:get_player_name(), "Your favorite color is " .. favorite_color .. "!")
    else
        minetest.chat_send_player(player:get_player_name(), "No favorite color stored.")
    end
end)


minetest.register_on_joinplayer(function(player)
	player:set_hp(2,"set_hp")
	player:set_properties({
		hp_max = 2
	})
	player:set_hp(5,"set_hp")
	
end)
local delta_carry=0
local function for_each_player(dtime)
	for _, player in ipairs(minetest.get_connected_players()) do
		delta_carry = delta_carry + dtime

		local health = player:get_hp()
			local regen_amount = math.floor(delta_carry)
			if regen_amount >= 1 then	
				delta_carry = delta_carry-regen_amount
			end
			if health < player:get_properties().hp_max then 
				--player:set_hp(health + regen_amount)
				--minetest.log("dtime:"..regen_amount)
			end
	end
		--minetest.after(0.01,for_each_player)
end

minetest.register_globalstep(for_each_player)

