-- Function to check if a point is inside an AABB
local function isinside_aabb(point, minp, maxp)
	return point.x >= minp.x and point.x <= maxp.x and
		   point.y >= minp.y and point.y <= maxp.y and
		   point.z >= minp.z and point.z <= maxp.z
end

-- Example usage

local function genarateFloor(point, minp, maxp, air, floor)
	local nfloor = minetest.get_content_id("green")
	local nair = minetest.get_content_id("air")


	if isinside_aabb(point, minp, maxp) then
		return air
	else
		return floor
	end



end
minetest.register_on_generated(function(minp, maxp, seed)
	local vm, emin, emax = minetest.get_mapgen_object("voxelmanip")
	local data = vm:get_data()
	local area = VoxelArea:new{MinEdge = emin, MaxEdge = emax}

	local nfloor = minetest.get_content_id("mapgen_stone")
	local nair = minetest.get_content_id("air")

	-- Iterate through the area
	for z = minp.z, maxp.z do
		for y = minp.y, maxp.y do
			for x = minp.x, maxp.x do
				local index = area:index(x, y, z)
				if y == 0 then
				
					data[index] = nfloor
				elseif y < 0 then
					--data[index] = nfloor
					local roomminp = {x = -8, y = -8, z = -8} 
					local roommaxp = {x = 8, y = 8, z = 8}

					data[index] = genarateFloor({x = x, y = y, z = z}, roomminp, roommaxp, nair, nfloor)
				else
					data[index] = nair
				end
			end
		end
	end

	vm:set_data(data)
	vm:write_to_map()
	vm:update_map()
end)

-- Function to be executed on spawn
local function onSpawn(player)
	return true --returns true from function to disable regular player placement
end



-- Call function when player spawns or respawns
minetest.register_on_respawnplayer(onSpawn)
minetest.register_on_joinplayer(function(player)
	minetest.after(0, function()
			onSpawn(player)
	end)
end) -- i hate that is a thing, TODO: fix this

